/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing.logging.log4j;

import com.google.common.collect.ImmutableList;
import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.FullyTested;
import com.googlecode.kevinarpe.papaya.annotation.ReadOnlyContainer;
import com.googlecode.kevinarpe.papaya.testing.logging.CapturingLogger;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@FullyTested
public class Log4JTestBase
implements CapturingLogger<LoggingEvent> {
    private final Appender _mockAppender = (Appender)Mockito.mock(Appender.class);

    protected Log4JTestBase() {
    }

    protected final void addMockAppender() {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.addAppender(this._mockAppender);
    }

    protected final void removeMockAppender() {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.removeAppender(this._mockAppender);
    }

    @EmptyContainerAllowed
    @ReadOnlyContainer
    public final List<LoggingEvent> getLoggingEventList() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(LoggingEvent.class);
        try {
            ((Appender)Mockito.verify((Object)this._mockAppender, (VerificationMode)Mockito.atLeastOnce())).doAppend((LoggingEvent)argumentCaptor.capture());
            List x = argumentCaptor.getAllValues();
            return x;
        }
        catch (Throwable ignore) {
            return ImmutableList.of();
        }
    }
}

