package com.googlecode.jpattern.shared.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public class ErrorMessage implements  IErrorMessage {

    private static final long serialVersionUID = 1L;

    private String propertyName;
    
    private String propertyMessage;

    private List<String> parameters;
    
    public ErrorMessage(String propertyName, String propertyMessage) {
    	this(propertyName, propertyMessage, new ArrayList<String>());
    }    
    
    public ErrorMessage(String propertyName, String propertyMessage, String[] parameters) {
    	this(propertyName, propertyMessage, Arrays.asList(parameters));
    }
    
    public ErrorMessage(String propertyName, String propertyMessage, List<String> parameters) {
    	this.propertyMessage = propertyMessage;
    	this.propertyName = propertyName;
    	this.parameters = parameters;
    }

    @Override
    public String getMessage() {
        return propertyMessage;
    }

    @Override
    public String getName() {
        return propertyName;
    }
    
    @Override
    public List<String> getParameters() {
        if (parameters==null) {
            parameters = new ArrayList<String>();
        }
        return parameters;
    }    
}
