package com.googlecode.jpattern.shared.command;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import com.googlecode.jpattern.shared.result.IErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public class BaseCommandResult implements IBaseCommandResult {
    
    private static final long serialVersionUID = 1L;

    private List<IErrorMessage> errorMessages;

    public BaseCommandResult() {
        errorMessages = new Vector<IErrorMessage>();
    }
    
    @Override
    public List<IErrorMessage> getErrorMessages() {
    	if ( errorMessages == null ) {
    		errorMessages = new Vector<IErrorMessage>();
    	}
        return errorMessages;
    }

    @Override
	public void addErrorMessage(IErrorMessage errorMessage) {
		getErrorMessages().add(errorMessage);		
	}
    
    @Override
    public boolean isValid() {
        return getErrorMessages().size() == 0;
    }

    @Override
    public String asString() {

        StringBuffer buffer = new StringBuffer();
        buffer.append("[ \n");
        buffer.append("{ isValid = " + isValid() + " } \n");
      //  buffer.append("{ returnObject = " + returnedObject() + " } \n");
        buffer.append("{ errormessages = \n");
        for (Iterator<IErrorMessage> iter = errorMessages.iterator(); iter.hasNext();) {
            IErrorMessage msg = (IErrorMessage) iter.next();
            buffer.append("( " + msg.getName() + " : " + msg.getMessage());
            int len = msg.getParameters().size();
            for (int i = 0; i < len; i++) {
                buffer.append(" " + msg.getParameters().get(i) + "  ");
            }
            buffer.append(" )");
        }
        buffer.append(" }\n");
        buffer.append(" ] ");

        return buffer.toString();

    }

}
