package com.googlecode.jpattern.shared.command;

/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 * 
 * A simple implentation of the Command pattern.
 * This class doesn't catch exeption thrown during the execution,
 * neither automatically launch the rollback in case of error,
 * the user is in charge of all those actions. 
 * 
 */
public abstract class ABaseCommand implements IBaseCommand {

    private static final long serialVersionUID = 1L;

    private IBaseCommand previousCommand;

    private boolean executed = false;

    public ABaseCommand(IBaseCommand previousCommand) {
        this.previousCommand = previousCommand;
    }
    
    private IBaseCommand getPreviousCommand() {
        if (previousCommand == null) {
            return new NullBaseCommand();
        }
        return previousCommand;
    }

    @Override
    public final IBaseCommandResult exec() {
        IBaseCommandResult result = getPreviousCommand().exec();
        if (result.isValid()) {
            result(result);
            executed = true;
        }
       
        return result;
    }
    
    @Override
    public final IBaseCommandResult rollback(IBaseCommandResult execResult) {
    	if (!execResult.isValid()) {
    		return rollback();
    	}
    	return new BaseCommandResult(); 
    }
    
    @Override
    public final IBaseCommandResult rollback() {
    	BaseCommandResult rollbackResult = new BaseCommandResult();
        if (executed) {
        	internalRollBack(rollbackResult);
        }
        rollbackResult.getErrorMessages().addAll(getPreviousCommand().rollback().getErrorMessages());
        return rollbackResult;
    }

    protected abstract void result(IBaseCommandResult result);
    
    protected abstract void internalRollBack(IBaseCommandResult rollBackResult);
    
}
