/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import java.util.LinkedHashSet;
import java.util.Set;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.GwtDomHelper;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.NodeTraversalChecker;
import se.fishtank.css.selectors.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagChecker
extends NodeTraversalChecker {
    private Set<Node> nodes;
    private Set<Node> result;
    private final Selector selector;

    public TagChecker(Selector selector) {
        Assert.notNull(selector, "selector is null!");
        this.selector = selector;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        this.nodes = nodes;
        this.result = new LinkedHashSet<Node>();
        switch (this.selector.getCombinator()) {
            case DESCENDANT: {
                this.addDescentantElements();
                break;
            }
            case CHILD: {
                this.addChildElements();
                break;
            }
            case ADJACENT_SIBLING: {
                this.addAdjacentSiblingElements();
                break;
            }
            case GENERAL_SIBLING: {
                this.addGeneralSiblingElements();
            }
        }
        return this.result;
    }

    private void addAdjacentSiblingElements() {
        for (Node node : this.nodes) {
            String tag;
            Element n = GwtDomHelper.getNextSiblingElement(node);
            if (n == null || !(tag = this.selector.getTagName()).equalsIgnoreCase(n.getNodeName()) && !tag.equals("*")) continue;
            this.result.add((Node)n);
        }
    }

    private void addChildElements() {
        for (Node node : this.nodes) {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String tag;
                node = nl.getItem(i);
                if (node.getNodeType() != 1 || !(tag = this.selector.getTagName()).equalsIgnoreCase(node.getNodeName()) && !tag.equals("*")) continue;
                this.result.add(node);
            }
        }
    }

    private void addDescentantElements() throws NodeSelectorException {
        for (Node node : this.nodes) {
            NodeList nl;
            if (node.getNodeType() == 9) {
                Document document = (Document)node.cast();
                nl = document.getElementsByTagName(this.selector.getTagName());
            } else if (node.getNodeType() == 1) {
                Element element = (Element)node.cast();
                nl = element.getElementsByTagName(this.selector.getTagName());
            } else {
                throw new NodeSelectorException("Only document and element nodes allowed!");
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                this.result.add(nl.getItem(i));
            }
        }
    }

    private void addGeneralSiblingElements() {
        for (Node node : this.nodes) {
            Element n = GwtDomHelper.getNextSiblingElement(node);
            while (n != null) {
                if (this.selector.getTagName().equalsIgnoreCase(n.getNodeName()) || this.selector.getTagName().equals("*")) {
                    this.result.add((Node)n);
                }
                n = GwtDomHelper.getNextSiblingElement((Node)n);
            }
        }
    }
}

