/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.Specifier;

class PseudoNthSpecifier
implements Specifier {
    private int a = 0;
    private final String argument;
    private int b = 0;
    private final String value;

    public PseudoNthSpecifier(String value, String argument) {
        Assert.notNull(value, "value is null!");
        Assert.notNull(argument, "argument is null!");
        this.value = value;
        this.argument = argument;
        this.parseNth();
    }

    public String getArgument() {
        return this.argument;
    }

    public Specifier.Type getType() {
        return Specifier.Type.PSEUDO;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isMatch(int count) {
        if (this.a == 0) {
            return count == this.b;
        }
        if (this.a > 0) {
            if (count < this.b) {
                return false;
            }
            return (count - this.b) % this.a == 0;
        }
        if (count > this.b) {
            return false;
        }
        return (this.b - count) % -this.a == 0;
    }

    private void parseNth() {
        String str = this.argument.replaceAll("\\+|\\s+", "");
        if ("odd".equals(str)) {
            this.a = 2;
            this.b = 1;
        } else if ("even".equals(str)) {
            this.a = 2;
        } else {
            int n = str.indexOf(110);
            if (n != -1) {
                this.a = n == 0 ? 1 : (n == 1 && str.charAt(0) == '-' ? -1 : Integer.parseInt(str.substring(0, n)));
                if (n + 1 != str.length()) {
                    this.b = Integer.parseInt(str.substring(n + 1, str.length()));
                }
            } else {
                this.b = Integer.parseInt(str);
            }
        }
    }
}

