/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import java.util.LinkedHashSet;
import java.util.Set;
import se.fishtank.css.selectors.Assert;
import se.fishtank.css.selectors.GwtDomHelper;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.NodeTraversalChecker;
import se.fishtank.css.selectors.PseudoClassSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PseudoClassSpecifierChecker
extends NodeTraversalChecker {
    private Set<Node> nodes;
    private Set<Node> result;
    private Node root;
    private final PseudoClassSpecifier specifier;

    public PseudoClassSpecifierChecker(PseudoClassSpecifier specifier) {
        Assert.notNull(specifier, "specifier is null!");
        this.specifier = specifier;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        Assert.notNull(root, "root is null!");
        this.nodes = nodes;
        this.root = root;
        this.result = new LinkedHashSet<Node>();
        String value = this.specifier.getValue();
        if ("empty".equals(value)) {
            this.addEmptyElements();
        } else if ("first-child".equals(value)) {
            this.addFirstChildElements();
        } else if ("first-of-type".equals(value)) {
            this.addFirstOfType();
        } else if ("last-child".equals(value)) {
            this.addLastChildElements();
        } else if ("last-of-type".equals(value)) {
            this.addLastOfType();
        } else if ("only-child".equals(value)) {
            this.addOnlyChildElements();
        } else if ("only-of-type".equals(value)) {
            this.addOnlyOfTypeElements();
        } else if ("root".equals(value)) {
            this.addRootElement();
        } else {
            throw new NodeSelectorException("Unknown pseudo class: " + value);
        }
        return this.result;
    }

    private void addEmptyElements() {
        for (Node node : this.nodes) {
            boolean empty = true;
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String value;
                Node n = nl.getItem(i);
                if (n.getNodeType() == 1) {
                    empty = false;
                    break;
                }
                if (n.getNodeType() != 3 || (value = n.getNodeValue().trim()).length() <= 0) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            this.result.add(node);
        }
    }

    private void addFirstChildElements() {
        for (Node node : this.nodes) {
            if (GwtDomHelper.getPreviousSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addFirstOfType() {
        for (Node node : this.nodes) {
            Element n = GwtDomHelper.getPreviousSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = GwtDomHelper.getPreviousSiblingElement((Node)n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addLastChildElements() {
        for (Node node : this.nodes) {
            if (GwtDomHelper.getNextSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addLastOfType() {
        for (Node node : this.nodes) {
            Element n = GwtDomHelper.getNextSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = GwtDomHelper.getNextSiblingElement((Node)n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addOnlyChildElements() {
        for (Node node : this.nodes) {
            if (GwtDomHelper.getPreviousSiblingElement(node) != null || GwtDomHelper.getNextSiblingElement(node) != null) continue;
            this.result.add(node);
        }
    }

    private void addOnlyOfTypeElements() {
        for (Node node : this.nodes) {
            Element n = GwtDomHelper.getPreviousSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = GwtDomHelper.getPreviousSiblingElement((Node)n);
            }
            if (n != null) continue;
            n = GwtDomHelper.getNextSiblingElement(node);
            while (n != null && !n.getNodeName().equals(node.getNodeName())) {
                n = GwtDomHelper.getNextSiblingElement((Node)n);
            }
            if (n != null) continue;
            this.result.add(node);
        }
    }

    private void addRootElement() {
        if (this.root.getNodeType() == 9) {
            Element element = GwtDomHelper.getFirstChildElement(this.root);
            Assert.notNull(element, "there should be a root element!");
            this.result.add((Node)element);
        } else {
            Assert.isTrue(this.root.getNodeType() == 1, "root must be a document or element node!");
            this.result.add(this.root);
        }
    }
}

