/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gxt.test.internal.patchers;

import com.extjs.gxt.ui.client.core.DomHelper;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.Element;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.utils.GwtHtmlParser;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;

@PatchClass(value=DomHelper.class)
class DomHelperPatcher {
    DomHelperPatcher() {
    }

    @PatchMethod
    static Element append(Element elem, String html) {
        NodeList parsedNodes = GwtHtmlParser.parse((String)html, (boolean)true);
        for (int i = 0; i < parsedNodes.getLength(); ++i) {
            Node current = parsedNodes.getItem(i);
            elem.appendChild(current);
        }
        return elem;
    }

    @PatchMethod
    static Element insertAfter(Element elem, String html) {
        Element parent = (Element)elem.getParentElement().cast();
        NodeList parsedNodes = GwtHtmlParser.parse((String)html, (boolean)true);
        for (int i = 0; i < parsedNodes.getLength(); ++i) {
            Element previous = i > 0 ? parsedNodes.getItem(i - 1) : elem;
            Node next = parsedNodes.getItem(i);
            parent.insertAfter(next, (Node)previous);
        }
        return parent;
    }

    @PatchMethod
    static Element insertBefore(Element elem, String html) {
        Element parent = (Element)elem.getParentElement().cast();
        NodeList parsedNodes = GwtHtmlParser.parse((String)html, (boolean)true);
        parent.insertBefore(parsedNodes.getItem(0), (Node)elem);
        for (int i = 1; i < parsedNodes.getLength(); ++i) {
            Node next = parsedNodes.getItem(i);
            parent.insertAfter(next, parsedNodes.getItem(i - 1));
        }
        return parent;
    }

    @PatchMethod
    static Element insertFirst(Element elem, String html) {
        NodeList parsedNodes = GwtHtmlParser.parse((String)html, (boolean)true);
        elem.insertFirst(parsedNodes.getItem(0));
        for (int i = 1; i < parsedNodes.getLength(); ++i) {
            Node current = parsedNodes.getItem(i);
            elem.insertAfter(current, parsedNodes.getItem(i - 1));
        }
        return elem;
    }

    @PatchMethod
    static Element insertHtml(String where, Element el, String html) {
        if ("beforeBegin".equals(where)) {
            return DomHelperPatcher.insertBefore(el, html);
        }
        if ("afterBegin".equals(where)) {
            return DomHelperPatcher.insertFirst(el, html);
        }
        if ("beforeEnd".equals(where)) {
            return DomHelperPatcher.append(el, html);
        }
        if ("afterEnd".equals(where)) {
            return DomHelperPatcher.insertAfter(el, html);
        }
        throw new GwtTestPatchException("Cannot insert html at position '" + where + "', the only allowed values are ' beforeBegin / afterBegin / beforeEnd / afterEnd '");
    }
}

