/*
 * Decompiled with CFR 0.152.
 */
package org.etlunit.feature.oracle_database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.etlunit.feature.database.BaseDatabaseImplemenation;
import org.etlunit.feature.database.DatabaseConnection;
import org.etlunit.feature.database.DatabaseImplementation;
import org.etlunit.parser.ETLTestValueObject;

public class OracleDatabaseImplementation
extends BaseDatabaseImplemenation {
    public DatabaseImplementation.data_format getDataFormatForExtract(ETLTestValueObject operands) {
        return null;
    }

    public DatabaseImplementation.database_state getDatabaseState(DatabaseConnection databaseConnection, String s) {
        return DatabaseImplementation.database_state.fail;
    }

    public String getImplementationId() {
        return "oracle";
    }

    public Object processOperation(DatabaseImplementation.operation op, DatabaseImplementation.OperationRequest request) throws UnsupportedOperationException {
        switch (op) {
            case executeSql: {
                break;
            }
            case createDatabase: {
                break;
            }
            case completeDatabaseInitialization: {
                break;
            }
            case prepareDatabase: {
                DatabaseImplementation.PrepareRequest prepReq = request.getPrepareRequest();
                try {
                    Connection conn = this.getConnection(prepReq.getConnection(), prepReq.getMode());
                    Statement st = conn.createStatement();
                    Statement trunc_st = conn.createStatement();
                    ResultSet rs = st.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE' AND TABLE_SCHEMA != 'SYSTEM_LOBS'");
                    while (rs.next()) {
                        trunc_st.addBatch("TRUNCATE TABLE " + rs.getString(1) + "." + rs.getString(2));
                    }
                    trunc_st.executeBatch();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error preparing database", e);
                }
            }
        }
        return null;
    }

    protected String getJdbcUrl(DatabaseConnection dc, String mode, int id) {
        return "jdbc:oracle:/" + dc.getServerName() + "/" + dc.getDatabaseName(mode);
    }

    protected Class getJdbcDriverClass() {
        return ((Object)((Object)this)).getClass();
    }

    public String getDefaultSchema(DatabaseConnection databaseConnection, String mode) {
        return "PUBLIC";
    }
}

