/*
 * Decompiled with CFR 0.152.
 */
package autoincrement;

import autoincrement.IncrementVersion;
import autoincrement.SnapshotAppender;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="toSnapshot", threadSafe=true, defaultPhase=LifecyclePhase.NONE, requiresProject=true)
public class ToSnapshotMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(property="autoincrement.environmentVariableName", defaultValue="newVersion", required=true)
    private String environmentVariableName;
    @Parameter(property="autoincrement.increaseVersionNumber", defaultValue="true")
    private boolean increaseVersionNumber;
    @Parameter(property="autoincrement.versionNumberPrefix", defaultValue="1.0.")
    private String versionNumberPrefix;
    private String versionNumber;

    public void execute() throws MojoFailureException {
        this.versionNumber = this.mavenProject.getVersion();
        if (this.increaseVersionNumber) {
            this.incrementVersionNumber();
        }
        this.addSnapshotToVersionNumber();
        this.storeNewVersionInEnvironment();
    }

    private void incrementVersionNumber() {
        IncrementVersion incrementVersion = IncrementVersion.withPrefix((String)this.versionNumberPrefix);
        incrementVersion.process(this.versionNumber);
        this.versionNumber = incrementVersion.getIncrementedVersion();
        this.getLog().debug((CharSequence)("Incremented version: " + this.versionNumber));
    }

    private void addSnapshotToVersionNumber() {
        SnapshotAppender snapshotAppender = new SnapshotAppender();
        snapshotAppender.process(this.versionNumber);
        this.versionNumber = snapshotAppender.getVersionWithSnapshot();
        this.getLog().debug((CharSequence)("Version with snapshot: " + this.versionNumber));
    }

    private void storeNewVersionInEnvironment() {
        this.mavenProject.getProperties().setProperty(this.environmentVariableName, this.versionNumber);
        this.getLog().info((CharSequence)String.format("Setting environment variable '%s' to '%s'", this.environmentVariableName, this.versionNumber));
    }
}

