/*
 * Decompiled with CFR 0.152.
 */
package autoincrement;

import autoincrement.SnapshotRemover;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="toRelease", threadSafe=true, defaultPhase=LifecyclePhase.NONE, requiresProject=true)
public class ToReleaseMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(property="autoincrement.environmentVariableName", defaultValue="newVersion", required=true)
    private String environmentVariableName;
    private String versionNumber;

    public void execute() throws MojoFailureException {
        this.versionNumber = this.mavenProject.getVersion();
        this.removeSnapshotFromVersion();
        this.storeNewVersionInEnvironment();
    }

    private void removeSnapshotFromVersion() {
        SnapshotRemover snapshotRemover = new SnapshotRemover();
        snapshotRemover.process(this.versionNumber);
        this.versionNumber = snapshotRemover.getVersionWithoutSnapshot();
        this.getLog().debug((CharSequence)("Version without snapshot: " + this.versionNumber));
    }

    private void storeNewVersionInEnvironment() {
        this.mavenProject.getProperties().setProperty(this.environmentVariableName, this.versionNumber);
        this.getLog().info((CharSequence)String.format("Setting environment variable '%s' to '%s'", this.environmentVariableName, this.versionNumber));
    }
}

