/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.maps.mapsplatformdatasets.v1alpha.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.Dataset;
import com.google.maps.mapsplatformdatasets.v1alpha.DatasetName;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.DeleteDatasetVersionRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetVersionsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1alpha.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1alpha.MapsPlatformDatasetsV1AlphaClient;
import com.google.maps.mapsplatformdatasets.v1alpha.MapsPlatformDatasetsV1AlphaSettings;
import com.google.maps.mapsplatformdatasets.v1alpha.MockMapsPlatformDatasetsV1Alpha;
import com.google.maps.mapsplatformdatasets.v1alpha.ProjectName;
import com.google.maps.mapsplatformdatasets.v1alpha.State;
import com.google.maps.mapsplatformdatasets.v1alpha.UpdateDatasetMetadataRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapsPlatformDatasetsV1AlphaClientTest {
    private static MockMapsPlatformDatasetsV1Alpha mockMapsPlatformDatasetsV1Alpha;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MapsPlatformDatasetsV1AlphaClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMapsPlatformDatasetsV1Alpha = new MockMapsPlatformDatasetsV1Alpha();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMapsPlatformDatasetsV1Alpha));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MapsPlatformDatasetsV1AlphaSettings settings = ((MapsPlatformDatasetsV1AlphaSettings.Builder)((MapsPlatformDatasetsV1AlphaSettings.Builder)MapsPlatformDatasetsV1AlphaSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MapsPlatformDatasetsV1AlphaClient.create((MapsPlatformDatasetsV1AlphaSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(State.forNumber((int)0)).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = this.client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(State.forNumber((int)0)).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = this.client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatasetMetadataTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(State.forNumber((int)0)).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        Dataset dataset = Dataset.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Dataset actualResponse = this.client.updateDatasetMetadata(dataset, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatasetMetadataRequest actualRequest = (UpdateDatasetMetadataRequest)actualRequests.get(0);
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatasetMetadataExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            Dataset dataset = Dataset.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDatasetMetadata(dataset, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(State.forNumber((int)0)).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(State.forNumber((int)0)).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetVersionsTest() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetVersionsResponse expectedResponse = ListDatasetVersionsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse pagedListResponse = this.client.listDatasetVersions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetVersionsRequest actualRequest = (ListDatasetVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetVersionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.listDatasetVersions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetVersionsTest2() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetVersionsResponse expectedResponse = ListDatasetVersionsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MapsPlatformDatasetsV1AlphaClient.ListDatasetVersionsPagedResponse pagedListResponse = this.client.listDatasetVersions(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetVersionsRequest actualRequest = (ListDatasetVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetVersionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listDatasetVersions(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest2() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MapsPlatformDatasetsV1AlphaClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        this.client.deleteDataset(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteDataset(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetVersionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        this.client.deleteDatasetVersion(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetVersionRequest actualRequest = (DeleteDatasetVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetVersionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.deleteDatasetVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetVersionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasetsV1Alpha.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteDatasetVersion(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasetsV1Alpha.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetVersionRequest actualRequest = (DeleteDatasetVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetVersionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasetsV1Alpha.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDatasetVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

