/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.maps.mapsplatformdatasets.v1.CreateDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.Dataset;
import com.google.maps.mapsplatformdatasets.v1.DatasetName;
import com.google.maps.mapsplatformdatasets.v1.DeleteDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.GetDatasetRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsRequest;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsClient;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsSettings;
import com.google.maps.mapsplatformdatasets.v1.MockMapsPlatformDatasets;
import com.google.maps.mapsplatformdatasets.v1.ProjectName;
import com.google.maps.mapsplatformdatasets.v1.Status;
import com.google.maps.mapsplatformdatasets.v1.UpdateDatasetMetadataRequest;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapsPlatformDatasetsClientTest {
    private static MockMapsPlatformDatasets mockMapsPlatformDatasets;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MapsPlatformDatasetsClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMapsPlatformDatasets = new MockMapsPlatformDatasets();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMapsPlatformDatasets));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MapsPlatformDatasetsSettings settings = ((MapsPlatformDatasetsSettings.Builder)((MapsPlatformDatasetsSettings.Builder)MapsPlatformDatasetsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MapsPlatformDatasetsClient.create((MapsPlatformDatasetsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = this.client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = this.client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatasetRequest actualRequest = (CreateDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Dataset dataset = Dataset.newBuilder().build();
            this.client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatasetMetadataTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        Dataset dataset = Dataset.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Dataset actualResponse = this.client.updateDatasetMetadata(dataset, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatasetMetadataRequest actualRequest = (UpdateDatasetMetadataRequest)actualRequests.get(0);
        Assert.assertEquals((Object)dataset, (Object)actualRequest.getDataset());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatasetMetadataExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            Dataset dataset = Dataset.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDatasetMetadata(dataset, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Dataset actualResponse = this.client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatasetRequest actualRequest = (GetDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MapsPlatformDatasetsClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest2() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MapsPlatformDatasetsClient.ListDatasetsPagedResponse pagedListResponse = this.client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatasetsRequest actualRequest = (ListDatasetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatasetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        this.client.deleteDataset(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            this.client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMapsPlatformDatasets.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteDataset(name);
        List<AbstractMessage> actualRequests = mockMapsPlatformDatasets.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatasetRequest actualRequest = (DeleteDatasetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatasetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(io.grpc.Status.INVALID_ARGUMENT);
        mockMapsPlatformDatasets.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

