/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.mapsplatformdatasets.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.Lists;
import com.google.maps.mapsplatformdatasets.v1.Dataset;
import com.google.maps.mapsplatformdatasets.v1.DatasetName;
import com.google.maps.mapsplatformdatasets.v1.ListDatasetsResponse;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsClient;
import com.google.maps.mapsplatformdatasets.v1.MapsPlatformDatasetsSettings;
import com.google.maps.mapsplatformdatasets.v1.ProjectName;
import com.google.maps.mapsplatformdatasets.v1.Status;
import com.google.maps.mapsplatformdatasets.v1.stub.HttpJsonMapsPlatformDatasetsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapsPlatformDatasetsClientHttpJsonTest {
    private static MockHttpService mockService;
    private static MapsPlatformDatasetsClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonMapsPlatformDatasetsStub.getMethodDescriptors(), MapsPlatformDatasetsSettings.getDefaultEndpoint());
        MapsPlatformDatasetsSettings settings = ((MapsPlatformDatasetsSettings.Builder)((MapsPlatformDatasetsSettings.Builder)MapsPlatformDatasetsSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)MapsPlatformDatasetsSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = MapsPlatformDatasetsClient.create((MapsPlatformDatasetsSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatasetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            Dataset dataset = Dataset.newBuilder().build();
            client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        Dataset dataset = Dataset.newBuilder().build();
        Dataset actualResponse = client.createDataset(parent, dataset);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatasetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            Dataset dataset = Dataset.newBuilder().build();
            client.createDataset(parent, dataset);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatasetMetadataTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockService.addResponse((Object)expectedResponse);
        Dataset dataset = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Dataset actualResponse = client.updateDatasetMetadata(dataset, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDatasetMetadataExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Dataset dataset = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDatasetMetadata(dataset, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockService.addResponse((Object)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        Dataset actualResponse = client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatasetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatasetTest2() throws Exception {
        Dataset expectedResponse = Dataset.newBuilder().setName(DatasetName.of((String)"[PROJECT]", (String)"[DATASET]").toString()).setDisplayName("displayName1714148973").setDescription("description-1724546052").setVersionId("versionId-1407102957").addAllUsage(new ArrayList()).setStatus(Status.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setVersionCreateTime(Timestamp.newBuilder().build()).setVersionDescription("versionDescription-1736173564").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2277/datasets/dataset-2277";
        Dataset actualResponse = client.getDataset(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatasetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2277/datasets/dataset-2277";
            client.getDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        MapsPlatformDatasetsClient.ListDatasetsPagedResponse pagedListResponse = client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatasetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatasetsTest2() throws Exception {
        Dataset responsesElement = Dataset.newBuilder().build();
        ListDatasetsResponse expectedResponse = ListDatasetsResponse.newBuilder().setNextPageToken("").addAllDatasets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        MapsPlatformDatasetsClient.ListDatasetsPagedResponse pagedListResponse = client.listDatasets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatasetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatasetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            client.listDatasets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
        client.deleteDataset(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDatasetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatasetName name = DatasetName.of((String)"[PROJECT]", (String)"[DATASET]");
            client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatasetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2277/datasets/dataset-2277";
        client.deleteDataset(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDatasetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2277/datasets/dataset-2277";
            client.deleteDataset(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

