/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.flink.bitcoin;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileInputSplit;
import org.zuinnote.flink.bitcoin.AbstractBitcoinFlinkInputFormat;
import org.zuinnote.flink.bitcoin.BitcoinBlockFlinkInputFormat;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinTransaction;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public class BitcoinTransactionFlinkInputFormat
extends AbstractBitcoinFlinkInputFormat<BitcoinTransaction>
implements CheckpointableInputFormat<FileInputSplit, Tuple2<Long, Long>> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockFlinkInputFormat.class.getName());
    private static final long serialVersionUID = 4150883073922261077L;
    private boolean isEndReached = false;
    private transient BitcoinBlock currentBitcoinBlock;
    private long currentTransactionCounterInBlock;

    public BitcoinTransactionFlinkInputFormat(int maxSizeBitcoinBlock, String specificMagicStr, boolean useDirectBuffer) throws HadoopCryptoLedgerConfigurationException {
        super(maxSizeBitcoinBlock, specificMagicStr, useDirectBuffer);
    }

    public boolean reachedEnd() throws IOException {
        return this.isEndReached;
    }

    public Tuple2<Long, Long> getCurrentState() throws IOException {
        return new Tuple2((Object)this.stream.getPos(), (Object)this.currentTransactionCounterInBlock);
    }

    public void reopen(FileInputSplit split, Tuple2<Long, Long> state) throws IOException {
        try {
            this.open(split);
        }
        finally {
            this.stream.seek(((Long)state.f0).longValue());
            this.currentTransactionCounterInBlock = (Long)state.f1;
        }
    }

    public BitcoinTransaction nextRecord(BitcoinTransaction reuse) throws IOException {
        BitcoinTransaction currentTransaction = null;
        if (this.currentSplit.getLength() < 0L || this.stream.getPos() <= this.currentSplit.getStart() + this.currentSplit.getLength()) {
            if (this.currentBitcoinBlock == null || (long)this.currentBitcoinBlock.getTransactions().size() == this.currentTransactionCounterInBlock) {
                try {
                    this.currentBitcoinBlock = this.getBbr().readBlock();
                    this.currentTransactionCounterInBlock = 0L;
                }
                catch (BitcoinBlockReadException e) {
                    LOG.error((Object)e);
                }
            }
            if (this.currentBitcoinBlock == null) {
                this.isEndReached = true;
            } else {
                currentTransaction = (BitcoinTransaction)this.currentBitcoinBlock.getTransactions().get((int)this.currentTransactionCounterInBlock);
                ++this.currentTransactionCounterInBlock;
            }
        } else {
            this.isEndReached = true;
        }
        return currentTransaction;
    }
}

