/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.flink.bitcoin;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.hadoop.io.BytesWritable;
import org.zuinnote.flink.bitcoin.AbstractBitcoinFlinkInputFormat;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public class BitcoinRawBlockFlinkInputFormat
extends AbstractBitcoinFlinkInputFormat<BytesWritable>
implements CheckpointableInputFormat<FileInputSplit, Long> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinRawBlockFlinkInputFormat.class.getName());
    private static final long serialVersionUID = 4150883073922261077L;
    private boolean isEndReached = false;

    public BitcoinRawBlockFlinkInputFormat(int maxSizeBitcoinBlock, String specificMagicStr, boolean useDirectBuffer) throws HadoopCryptoLedgerConfigurationException {
        super(maxSizeBitcoinBlock, specificMagicStr, useDirectBuffer);
    }

    public boolean reachedEnd() throws IOException {
        return this.isEndReached;
    }

    public Long getCurrentState() throws IOException {
        return this.stream.getPos();
    }

    public void reopen(FileInputSplit split, Long state) throws IOException {
        try {
            this.open(split);
        }
        finally {
            this.stream.seek(state.longValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BytesWritable nextRecord(BytesWritable reuse) throws IOException {
        byte[] dataBlockArray;
        ByteBuffer dataBlock = null;
        if (this.currentSplit.getLength() >= 0L && this.stream.getPos() > this.currentSplit.getStart() + this.currentSplit.getLength()) {
            this.isEndReached = true;
            return null;
        }
        try {
            dataBlock = this.getBbr().readRawBlock();
        }
        catch (BitcoinBlockReadException e) {
            LOG.error((Object)e);
        }
        if (dataBlock == null) {
            this.isEndReached = true;
            return null;
        }
        if (dataBlock.hasArray()) {
            dataBlockArray = dataBlock.array();
        } else {
            dataBlockArray = new byte[dataBlock.capacity()];
            dataBlock.get(dataBlockArray);
        }
        reuse.set(dataBlockArray, 0, dataBlockArray.length);
        return reuse;
    }
}

