/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.flink.bitcoin;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.zuinnote.flink.bitcoin.AbstractBitcoinFlinkInputFormat;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlock;
import org.zuinnote.hadoop.bitcoin.format.exception.BitcoinBlockReadException;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public class BitcoinBlockFlinkInputFormat
extends AbstractBitcoinFlinkInputFormat<BitcoinBlock>
implements CheckpointableInputFormat<FileInputSplit, Long> {
    private static final Log LOG = LogFactory.getLog((String)BitcoinBlockFlinkInputFormat.class.getName());
    private static final long serialVersionUID = 4150883073922261077L;
    private boolean isEndReached = false;

    public BitcoinBlockFlinkInputFormat(int maxSizeBitcoinBlock, String specificMagicStr, boolean useDirectBuffer) throws HadoopCryptoLedgerConfigurationException {
        super(maxSizeBitcoinBlock, specificMagicStr, useDirectBuffer);
    }

    public boolean reachedEnd() throws IOException {
        return this.isEndReached;
    }

    public Long getCurrentState() throws IOException {
        return this.stream.getPos();
    }

    public void reopen(FileInputSplit split, Long state) throws IOException {
        try {
            this.open(split);
        }
        finally {
            this.stream.seek(state.longValue());
        }
    }

    public BitcoinBlock nextRecord(BitcoinBlock reuse) throws IOException {
        BitcoinBlock dataBlock = null;
        if (this.currentSplit.getLength() < 0L || this.stream.getPos() <= this.currentSplit.getStart() + this.currentSplit.getLength()) {
            try {
                dataBlock = this.getBbr().readBlock();
            }
            catch (BitcoinBlockReadException e) {
                LOG.error((Object)e);
            }
            if (dataBlock == null) {
                this.isEndReached = true;
            }
        } else {
            this.isEndReached = true;
        }
        return dataBlock;
    }
}

