/*
 * Decompiled with CFR 0.152.
 */
package org.zuinnote.flink.bitcoin;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinBlockReader;
import org.zuinnote.hadoop.bitcoin.format.common.BitcoinUtil;
import org.zuinnote.hadoop.bitcoin.format.exception.HadoopCryptoLedgerConfigurationException;

public abstract class AbstractBitcoinFlinkInputFormat<E>
extends FileInputFormat<E> {
    private static final Log LOG = LogFactory.getLog((String)AbstractBitcoinFlinkInputFormat.class.getName());
    private transient BitcoinBlockReader bbr;
    private int maxSizeBitcoinBlock;
    private byte[][] specificMagicArray;
    private boolean useDirectBuffer;
    private static final long serialVersionUID = -4661705676237973665L;

    public AbstractBitcoinFlinkInputFormat() throws HadoopCryptoLedgerConfigurationException {
        this(0x200000, "F9BEB4D9", false);
    }

    public AbstractBitcoinFlinkInputFormat(int maxSizeBitcoinBlock, String specificMagicStr, boolean useDirectBuffer) throws HadoopCryptoLedgerConfigurationException {
        this.maxSizeBitcoinBlock = maxSizeBitcoinBlock;
        this.useDirectBuffer = useDirectBuffer;
        if (specificMagicStr != null && specificMagicStr.length() > 0) {
            String[] specificMagicStringArray = specificMagicStr.split(",");
            this.specificMagicArray = new byte[specificMagicStringArray.length][4];
            for (int i = 0; i < specificMagicStringArray.length; ++i) {
                byte[] currentMagicNo = BitcoinUtil.convertHexStringToByteArray((String)specificMagicStringArray[i]);
                if (currentMagicNo.length != 4) {
                    throw new HadoopCryptoLedgerConfigurationException("Error: Configuration. Magic number has not a length of 4 bytes. Index: " + i);
                }
                this.specificMagicArray[i] = currentMagicNo;
            }
        }
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        LOG.debug((Object)"Initialize Bitcoin reader");
        this.bbr = new BitcoinBlockReader((InputStream)this.stream, this.maxSizeBitcoinBlock, 1, this.specificMagicArray, this.useDirectBuffer);
    }

    public BitcoinBlockReader getBbr() {
        return this.bbr;
    }
}

