/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.utils;

import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesUtils {
    public static final Properties proInfo = new Properties();
    private static final String[] needProperties = new String[]{"DB_URL", "DB_TYPE", "DB_DRIVER", "DB_USERNAME", "DB_PASSWORD", "DB_TABLE_SCHEMA"};

    public static void loadProperties(InputStream resourceAsStream) throws IOException, IllegalArgumentException {
        proInfo.load(resourceAsStream);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < needProperties.length; ++i) {
            if (!PropertiesUtils.isBlank(PropertiesUtils.getProperties(needProperties[i]))) continue;
            sb.append("\u672a\u914d\u7f6e " + needProperties[i] + "  \n");
        }
        if (sb.length() > 0) {
            LogUtils.printErrInfo(sb.toString());
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static boolean isBlank(String properties) {
        return GeneratorStringUtils.isBlank(properties);
    }

    public static String getProperties(String key) {
        String property = proInfo.getProperty(key);
        return property == null ? null : property.trim();
    }

    public static boolean containsKey(String key) {
        return GeneratorStringUtils.isNotBlank(proInfo.getProperty(key));
    }

    public static boolean getBooleanPropertiesDefaultFalse(String key) {
        String properties = PropertiesUtils.getProperties(key);
        if (GeneratorStringUtils.isBlank(properties)) {
            return false;
        }
        try {
            return Boolean.parseBoolean(properties);
        }
        catch (Exception e) {
            LogUtils.printErrInfo("\u914d\u7f6e\u6709\u8bef,key=" + key + ",\u503c\u5e94\u4e3a true false");
            return false;
        }
    }

    public static boolean getBooleanPropertiesDefaultTrue(String key) {
        String properties = PropertiesUtils.getProperties(key);
        if (GeneratorStringUtils.isBlank(properties)) {
            return true;
        }
        try {
            return Boolean.parseBoolean(properties);
        }
        catch (Exception e) {
            LogUtils.printErrInfo("\u914d\u7f6e\u6709\u8bef,key=" + key + ",\u503c\u5e94\u4e3a true false");
            return true;
        }
    }
}

