/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.utils;

import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class Freemarker {
    public static void print(String ftlPath, String ftlName, Object root) throws Exception {
        try {
            Template temp = Freemarker.getTemplate(ftlPath, ftlName);
            temp.process(root, (Writer)new PrintWriter(System.out));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printFile(String ftlPath, String ftlName, Map<String, Object> root, String outFilePath, String outFile) throws Exception {
        try {
            File file = new File(outFilePath + outFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            Template template = Freemarker.getTemplate(ftlPath, ftlName);
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printFile(String ftlFullPath, String outPutPath, Object outPutObject) throws Exception {
        LogUtils.printInfo("\u6587\u4ef6\u8f93\u51fa\u8def\u5f84:" + outPutPath);
        Freemarker.printFile(GeneratorStringUtils.getFrontPath(ftlFullPath), GeneratorStringUtils.getFileName(ftlFullPath), outPutPath, outPutObject);
    }

    public static void printFile(String ftlPath, String ftlName, String outPutPath, Object outPutObject) throws Exception {
        try {
            File file = new File(outPutPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            Template template = Freemarker.getTemplate(ftlPath, ftlName);
            template.process(outPutObject, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Template getTemplate(String ftlPath, String ftlName) throws Exception {
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
            cfg.setEncoding(Locale.CHINA, "utf-8");
            cfg.setClassLoaderForTemplateLoading(Freemarker.class.getClassLoader(), ftlPath);
            Template temp = cfg.getTemplate(ftlName);
            return temp;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

