/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.vo;

import com.github.zhuyizhuo.generator.mybatis.convention.StratificationInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.ColumnInfo;
import com.github.zhuyizhuo.generator.mybatis.dto.JavaColumnInfo;
import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.PropertiesUtils;
import com.google.common.collect.Lists;
import java.util.LinkedHashSet;
import java.util.List;

public class TableInfo {
    private String tableSchema;
    private String tableName;
    private String tableComment;
    private String javaTableName;
    private LinkedHashSet<String> importPackages = new LinkedHashSet();
    private List<JavaColumnInfo> columnLists = Lists.newArrayList();
    private List<JavaColumnInfo> primaryKeyColumns = Lists.newArrayList();
    private List<JavaColumnInfo> otherColumns = Lists.newArrayList();
    private boolean hasPrimaryKey = true;
    private boolean singlePrimaryKey = true;
    private String parameterType;
    private String resultMapId;

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public List<JavaColumnInfo> getColumnLists() {
        return this.columnLists;
    }

    public void addJavaColumnInfo(JavaColumnInfo javaColumnInfo) {
        this.columnLists.add(javaColumnInfo);
    }

    public String getJavaTableName() {
        return this.javaTableName;
    }

    public void setJavaTableName(String javaTableName) {
        this.javaTableName = javaTableName;
    }

    public LinkedHashSet<String> getImportPackages() {
        return this.importPackages;
    }

    public void addImportPackage(String importPackage) {
        this.importPackages.add(importPackage);
    }

    public void addPrimaryKeyColumn(List<ColumnInfo> keyName) {
        if (keyName == null || keyName.size() == 0) {
            this.hasPrimaryKey = false;
            return;
        }
        block0: for (int i = 0; i < keyName.size(); ++i) {
            ColumnInfo columnInfo = keyName.get(i);
            String columnName = columnInfo.getColumnName();
            for (int j = 0; j < this.columnLists.size(); ++j) {
                JavaColumnInfo javaColumnInfo = this.columnLists.get(j);
                if (columnName == null || !columnName.equalsIgnoreCase(javaColumnInfo.getColumnName())) continue;
                this.primaryKeyColumns.add(javaColumnInfo);
                continue block0;
            }
        }
        this.initOtherColumns();
        this.hasPrimaryKey = true;
        this.singlePrimaryKey = this.primaryKeyColumns.size() == 1;
    }

    private void initOtherColumns() {
        for (int i = 0; i < this.columnLists.size(); ++i) {
            JavaColumnInfo javaColumnInfo = this.columnLists.get(i);
            if (this.primaryKeyColumns.contains(javaColumnInfo)) continue;
            this.otherColumns.add(javaColumnInfo);
        }
    }

    public List<JavaColumnInfo> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public boolean isHasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public void setHasPrimaryKey(boolean hasPrimaryKey) {
        this.hasPrimaryKey = hasPrimaryKey;
    }

    public List<JavaColumnInfo> getOtherColumns() {
        return this.otherColumns;
    }

    public void setOtherColumns(List<JavaColumnInfo> otherColumns) {
        this.otherColumns = otherColumns;
    }

    public boolean isSinglePrimaryKey() {
        return this.singlePrimaryKey;
    }

    public void setSinglePrimaryKey(boolean singlePrimaryKey) {
        this.singlePrimaryKey = singlePrimaryKey;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public String toString() {
        return "TableInfo{tableSchema='" + this.tableSchema + '\'' + ", tableName='" + this.tableName + '\'' + ", tableComment='" + this.tableComment + '\'' + ", javaTableName='" + this.javaTableName + '\'' + ", importPackages=" + this.importPackages + ", columnLists=" + this.columnLists + '}';
    }

    public void initXmlInfo(StratificationInfo stratificationInfo) {
        boolean useTypeAliases = PropertiesUtils.getBooleanPropertiesDefaultFalse("PARAMETER_TYPE_USE_TYPE_ALIASES");
        if (useTypeAliases) {
            this.setParameterType(GeneratorStringUtils.firstLower(stratificationInfo.getPojoName()));
        } else {
            this.setParameterType(stratificationInfo.getPojoFullPackage() + "." + stratificationInfo.getPojoName());
        }
        this.setResultMapId(GeneratorStringUtils.firstLower(this.javaTableName) + "ResultMap");
    }
}

