/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.generator;

import com.github.zhuyizhuo.generator.mybatis.constants.ConfigConstants;
import com.github.zhuyizhuo.generator.mybatis.convention.ClassCommentInfo;
import com.github.zhuyizhuo.generator.mybatis.convention.FileOutPathInfo;
import com.github.zhuyizhuo.generator.mybatis.convention.MethodCommentInfo;
import com.github.zhuyizhuo.generator.mybatis.convention.MethodInfo;
import com.github.zhuyizhuo.generator.mybatis.convention.StratificationInfo;
import com.github.zhuyizhuo.generator.mybatis.extension.service.FormatService;
import com.github.zhuyizhuo.generator.mybatis.extension.service.GeneratorService;
import com.github.zhuyizhuo.generator.mybatis.extension.service.impl.FreemarkerGenerator;
import com.github.zhuyizhuo.generator.mybatis.factory.DbServiceFactory;
import com.github.zhuyizhuo.generator.mybatis.generator.Generator;
import com.github.zhuyizhuo.generator.mybatis.vo.GenerateInfo;
import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import com.github.zhuyizhuo.generator.utils.PropertiesUtils;
import com.github.zhuyizhuo.generator.utils.TypeConversion;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;

public class GeneratorBuilder {
    private ClassCommentInfo classCommentInfo;
    private MethodCommentInfo methodCommentInfo;
    private MethodInfo methodInfo;
    private StratificationInfo stratificationInfo;
    private FileOutPathInfo fileOutPathInfo;
    private GeneratorService generatorService;
    private final Map<String, Class<?>> typeMapper = new HashMap();

    public GeneratorBuilder() {
        this(new ClassCommentInfo());
    }

    public GeneratorBuilder(ClassCommentInfo classCommentInfo) {
        this(classCommentInfo, new MethodInfo());
    }

    public GeneratorBuilder(ClassCommentInfo classCommentInfo, MethodInfo methodInfo) {
        this(classCommentInfo, methodInfo, new StratificationInfo());
    }

    public GeneratorBuilder(ClassCommentInfo classCommentInfo, MethodInfo methodInfo, StratificationInfo stratificationInfo) {
        this(classCommentInfo, methodInfo, stratificationInfo, new FileOutPathInfo());
    }

    public GeneratorBuilder(ClassCommentInfo classCommentInfo, MethodInfo methodInfo, StratificationInfo stratificationInfo, FileOutPathInfo fileOutPathInfo) {
        this(classCommentInfo, methodInfo, stratificationInfo, fileOutPathInfo, new MethodCommentInfo());
    }

    public GeneratorBuilder(ClassCommentInfo classCommentInfo, MethodInfo methodInfo, StratificationInfo stratificationInfo, FileOutPathInfo fileOutPathInfo, MethodCommentInfo methodCommentInfo) {
        this.classCommentInfo = classCommentInfo;
        this.methodCommentInfo = methodCommentInfo;
        this.methodInfo = methodInfo;
        this.stratificationInfo = stratificationInfo;
        this.fileOutPathInfo = fileOutPathInfo;
    }

    public GeneratorBuilder addXmlNameFormat(FormatService formatService) {
        this.stratificationInfo.addXmlNameFormat(formatService);
        return this;
    }

    public GeneratorBuilder addBeanNameFormat(FormatService formatService) {
        this.stratificationInfo.addBeanNameFormat(formatService);
        return this;
    }

    public GeneratorBuilder addMapperNameFormat(FormatService formatService) {
        this.stratificationInfo.addDaoNameFormat(formatService);
        return this;
    }

    public GeneratorBuilder addTableRegex(String tableRegex) {
        if (GeneratorStringUtils.isNotBlank(tableRegex)) {
            ConfigConstants.tableRegex = tableRegex;
        }
        return this;
    }

    public GeneratorBuilder addTypeMapper(String dataBaseType, JdbcType jdbcType, Class<?> javaTypeClass) {
        if (GeneratorStringUtils.isNotBlank(dataBaseType) && javaTypeClass != null) {
            this.typeMapper.put(dataBaseType, javaTypeClass);
        }
        if (GeneratorStringUtils.isNotBlank(dataBaseType) && jdbcType != null) {
            TypeConversion.addType2JdbcType(dataBaseType, jdbcType.toString());
        }
        return this;
    }

    public GeneratorBuilder addMethodComment(MethodCommentInfo commentInfo) {
        this.methodCommentInfo = commentInfo;
        return this;
    }

    public GeneratorBuilder addGeneratorService(GeneratorService generatorService) {
        this.generatorService = generatorService;
        return this;
    }

    public Generator build(InputStream inputStream) {
        try {
            PropertiesUtils.loadProperties(inputStream);
        }
        catch (Exception e) {
            LogUtils.printErrInfo("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25.");
        }
        TypeConversion.init(this.typeMapper);
        this.stratificationInfo.init();
        this.classCommentInfo.init();
        GenerateInfo generateInfo = new GenerateInfo();
        generateInfo.setClassCommentInfo(this.classCommentInfo);
        generateInfo.setMethodCommentInfo(this.methodCommentInfo);
        generateInfo.setMethodInfo(this.methodInfo);
        generateInfo.setStratificationInfo(this.stratificationInfo);
        this.fileOutPathInfo.init(this.stratificationInfo);
        this.initGeneratorService();
        return new Generator(DbServiceFactory.getDbService(), generateInfo, this.generatorService);
    }

    private void initGeneratorService() {
        if (this.generatorService == null) {
            this.generatorService = new FreemarkerGenerator(this.fileOutPathInfo);
        }
    }
}

