/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.generator;

import com.github.zhuyizhuo.generator.mybatis.db.service.DbService;
import com.github.zhuyizhuo.generator.mybatis.extension.service.GeneratorService;
import com.github.zhuyizhuo.generator.mybatis.vo.GenerateInfo;
import com.github.zhuyizhuo.generator.mybatis.vo.TableInfo;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import java.util.List;

public class Generator {
    private GeneratorService generatorService;
    private DbService service;
    private GenerateInfo generateInfo;

    public Generator(DbService service, GenerateInfo generateInfo, GeneratorService generatorService) {
        this.service = service;
        this.generateInfo = generateInfo;
        this.generatorService = generatorService;
    }

    public void generate() {
        try {
            List<TableInfo> tableColumns = this.service.getTableColumns();
            try {
                this.printAll(tableColumns);
            }
            catch (Exception e) {
                LogUtils.printErrInfo("\u751f\u6210\u6570\u636e\u5f02\u5e38!Exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.toString().contains("Error setting driver on UnpooledDataSource.")) {
                LogUtils.printErrInfo("\u8bf7\u68c0\u67e5\u662f\u5426\u6dfb\u52a0\u5bf9\u5e94\u6570\u636e\u5e93\u9a71\u52a8\u4f9d\u8d56!");
                LogUtils.printErrInfo("Exception: " + cause.toString());
            }
            LogUtils.printErrInfo("\u67e5\u8be2\u6570\u636e\u5e93\u7ed3\u6784\u5f02\u5e38!Exception:" + e.getMessage());
        }
    }

    public void printAll(List<TableInfo> dbTableInfoList) {
        try {
            if (dbTableInfoList == null || dbTableInfoList.size() == 0) {
                LogUtils.printInfo("\u4e0d\u5b58\u5728\u9700\u751f\u6210\u7684\u6570\u636e.");
                return;
            }
            for (int i = 0; i < dbTableInfoList.size(); ++i) {
                this.generateInfo.init(dbTableInfoList.get(i));
                this.generatorService.generate(this.generateInfo);
            }
        }
        catch (Exception e) {
            LogUtils.printErrInfo("\u751f\u6210\u6570\u636e\u5f02\u5e38!");
            e.printStackTrace();
        }
    }
}

