/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.factory;

import com.github.zhuyizhuo.generator.mybatis.db.service.DbService;
import com.github.zhuyizhuo.generator.mybatis.db.service.impl.MysqlDbServiceImpl;
import com.github.zhuyizhuo.generator.mybatis.db.service.impl.OracleDbServiceImpl;
import com.github.zhuyizhuo.generator.mybatis.enums.DbTypeEnums;
import com.github.zhuyizhuo.generator.utils.CheckUtils;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DbServiceFactory {
    private static Map<String, DbService> serviceMap = new ConcurrentHashMap<String, DbService>();

    public static DbService getDbService() {
        String dbType = CheckUtils.checkDBType();
        LogUtils.printInfo("\u6570\u636e\u5e93\u7c7b\u578b:" + dbType);
        DbService dbService = serviceMap.get(dbType);
        if (dbService == null) {
            String errorMsg = "DB_TYPE\u914d\u7f6e\u7c7b\u578b\u4e0d\u652f\u6301,\u6240\u652f\u6301\u7c7b\u578b\u8bf7\u53c2\u7167 DbTypeEnums.java";
            LogUtils.printErrInfo(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        return dbService;
    }

    static {
        serviceMap.put(DbTypeEnums.MYSQL.toString(), new MysqlDbServiceImpl());
        serviceMap.put(DbTypeEnums.ORACLE.toString(), new OracleDbServiceImpl());
    }
}

