/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.extension.service.impl;

import com.github.zhuyizhuo.generator.mybatis.constants.FtlPathInfo;
import com.github.zhuyizhuo.generator.mybatis.convention.FileOutPathInfo;
import com.github.zhuyizhuo.generator.mybatis.extension.service.GeneratorService;
import com.github.zhuyizhuo.generator.mybatis.vo.GenerateInfo;
import com.github.zhuyizhuo.generator.utils.Freemarker;
import com.github.zhuyizhuo.generator.utils.LogUtils;

public class FreemarkerGenerator
implements GeneratorService {
    private FtlPathInfo ftlPathInfo;
    private FileOutPathInfo fileOutPathInfo;

    public FreemarkerGenerator(FileOutPathInfo fileOutPathInfo) {
        this(new FtlPathInfo(), fileOutPathInfo);
    }

    public FreemarkerGenerator(FtlPathInfo ftlPathInfo, FileOutPathInfo fileOutPathInfo) {
        this.ftlPathInfo = ftlPathInfo;
        this.fileOutPathInfo = fileOutPathInfo;
    }

    @Override
    public void generate(GenerateInfo generateInfo) {
        this.fileOutPathInfo.formatPath(generateInfo.getStratificationInfo());
        try {
            Freemarker.printFile(this.ftlPathInfo.getPojoFtlPath(), this.fileOutPathInfo.getPojoOutPutFullPath(), generateInfo);
            Freemarker.printFile(this.ftlPathInfo.getDaoFtlPath(), this.fileOutPathInfo.getDaoOutPutFullPath(), generateInfo);
            Freemarker.printFile(this.ftlPathInfo.getMybatisXmlFtlPath(), this.fileOutPathInfo.getXmlOutPutFullPath(), generateInfo);
        }
        catch (Exception e) {
            LogUtils.printErrInfo("\u751f\u6210\u5f02\u5e38");
            e.printStackTrace();
        }
    }
}

