/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.db.service.impl;

import com.github.zhuyizhuo.generator.mybatis.database.mapper.OracleDataBaseMapper;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.ColumnInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DataBaseInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DbTableInfo;
import com.github.zhuyizhuo.generator.mybatis.db.service.abst.AbstractDbService;
import com.github.zhuyizhuo.generator.mybatis.utils.SqlSessionUtils;
import com.github.zhuyizhuo.generator.mybatis.vo.TableInfo;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import com.github.zhuyizhuo.generator.utils.TypeConversion;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

public class OracleDbServiceImpl
extends AbstractDbService {
    @Override
    public List<TableInfo> getTableColumns() {
        SqlSession sqlSession = SqlSessionUtils.getSqlSession();
        OracleDataBaseMapper mapper = (OracleDataBaseMapper)sqlSession.getMapper(OracleDataBaseMapper.class);
        DataBaseInfo dataBaseInfo = this.getDataBaseInfo();
        List<DbTableInfo> tableList = mapper.getTableNameListBySchema(dataBaseInfo);
        LogUtils.printInfo("\u5171\u67e5\u8be2\u51fa" + tableList.size() + "\u5f20\u8868.");
        List<TableInfo> tableInfos = this.getTableInfos(mapper, tableList);
        sqlSession.close();
        return tableInfos;
    }

    private List<TableInfo> getTableInfos(OracleDataBaseMapper mapper, List<DbTableInfo> tableList) {
        ArrayList tableInfos = Lists.newArrayList();
        TableInfo tableInfo = null;
        for (int i = 0; i < tableList.size(); ++i) {
            DbTableInfo dbTableInfo = tableList.get(i);
            String tableName = dbTableInfo.getTableName();
            DbTableInfo allColumnsByTable = mapper.getAllColumnsByTable(dbTableInfo.getTableSchema(), tableName);
            tableInfo = new TableInfo();
            this.setTableInfo(allColumnsByTable, tableInfo);
            tableInfo.setJavaTableName(this.getJavaTableName(tableName));
            tableInfo.addPrimaryKeyColumn(this.getPrimaryKeys(mapper, dbTableInfo));
            tableInfos.add(tableInfo);
            LogUtils.printInfo(tableName + "\u8868\u5171" + allColumnsByTable.getColumnLists().size() + "\u5217");
        }
        return tableInfos;
    }

    private List<ColumnInfo> getPrimaryKeys(OracleDataBaseMapper mapper, DbTableInfo dbTableInfo) {
        return mapper.getPrimaryKeys(dbTableInfo);
    }

    @Override
    protected String getJavaDataType(ColumnInfo columnInfo) {
        return TypeConversion.getTypeByMap(TypeConversion.oracleDbType2JavaMap, this.getDataType(columnInfo.getDataType()));
    }
}

