/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.db.service.impl;

import com.github.zhuyizhuo.generator.mybatis.database.mapper.MysqlDataBaseMapper;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.ColumnInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DataBaseInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DbTableInfo;
import com.github.zhuyizhuo.generator.mybatis.db.service.abst.AbstractDbService;
import com.github.zhuyizhuo.generator.mybatis.utils.SqlSessionUtils;
import com.github.zhuyizhuo.generator.mybatis.vo.TableInfo;
import com.github.zhuyizhuo.generator.utils.LogUtils;
import com.github.zhuyizhuo.generator.utils.TypeConversion;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;

public class MysqlDbServiceImpl
extends AbstractDbService {
    @Override
    public List<TableInfo> getTableColumns() {
        SqlSession sqlSession = SqlSessionUtils.getSqlSession();
        MysqlDataBaseMapper mapper = (MysqlDataBaseMapper)sqlSession.getMapper(MysqlDataBaseMapper.class);
        DataBaseInfo dataBaseInfo = this.getDataBaseInfo();
        List<DbTableInfo> tableList = mapper.getTableNameListBySchema(dataBaseInfo);
        LogUtils.printInfo("DataBaseInfo:" + dataBaseInfo + ",\u5171\u67e5\u8be2\u51fa" + tableList.size() + "\u5f20\u8868.");
        List<TableInfo> tableColumns = this.getTableColumns(mapper, tableList);
        sqlSession.close();
        return tableColumns;
    }

    private List<TableInfo> getTableColumns(MysqlDataBaseMapper mapper, List<DbTableInfo> tableList) {
        ArrayList lists = Lists.newArrayList();
        TableInfo tableInfo = null;
        for (int i = 0; i < tableList.size(); ++i) {
            tableInfo = new TableInfo();
            DbTableInfo dbTableInfo = tableList.get(i);
            dbTableInfo.setColumnLists(this.getColumnInfos(mapper, dbTableInfo));
            this.setTableInfo(dbTableInfo, tableInfo);
            tableInfo.setJavaTableName(this.getJavaTableName(dbTableInfo.getTableName()));
            tableInfo.addPrimaryKeyColumn(this.getPrimaryKeys(mapper, dbTableInfo));
            lists.add(tableInfo);
            LogUtils.printInfo(dbTableInfo.getTableName() + "\u8868\u5171" + dbTableInfo.getColumnLists().size() + "\u5217");
        }
        return lists;
    }

    private List<ColumnInfo> getPrimaryKeys(MysqlDataBaseMapper mapper, DbTableInfo dbTableInfo) {
        return mapper.getPrimaryKeys(dbTableInfo);
    }

    private List<ColumnInfo> getColumnInfos(MysqlDataBaseMapper mapper, DbTableInfo dbTableInfo) {
        return mapper.getColumnListByTableName(dbTableInfo);
    }

    @Override
    protected String getJavaDataType(ColumnInfo columnInfo) {
        return TypeConversion.getTypeByMap(TypeConversion.mySqlDbType2JavaMap, columnInfo.getDataType());
    }
}

