/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.db.service.abst;

import com.github.zhuyizhuo.generator.mybatis.constants.ConfigConstants;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.ColumnInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DataBaseInfo;
import com.github.zhuyizhuo.generator.mybatis.database.pojo.DbTableInfo;
import com.github.zhuyizhuo.generator.mybatis.db.service.DbService;
import com.github.zhuyizhuo.generator.mybatis.dto.JavaColumnInfo;
import com.github.zhuyizhuo.generator.mybatis.vo.TableInfo;
import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.PropertiesUtils;
import com.github.zhuyizhuo.generator.utils.TypeConversion;
import com.google.common.base.Splitter;
import java.util.List;

public abstract class AbstractDbService
implements DbService {
    protected DataBaseInfo getDataBaseInfo() {
        DataBaseInfo tableInfo = new DataBaseInfo();
        tableInfo.setTableSchema(this.getTableSchema());
        tableInfo.setTableNames(this.getTables());
        return tableInfo;
    }

    protected String getTableSchema() {
        String tableSchema = PropertiesUtils.getProperties("DB_TABLE_SCHEMA");
        if (GeneratorStringUtils.isNotBlank(tableSchema)) {
            tableSchema = tableSchema.toUpperCase();
        }
        return tableSchema;
    }

    protected List<String> getTables() {
        String includeTableName = PropertiesUtils.getProperties("DB_INCLUDE_TABLE_NAME");
        if (GeneratorStringUtils.isNotBlank(includeTableName)) {
            return Splitter.on((String)",").splitToList((CharSequence)includeTableName);
        }
        return null;
    }

    protected void setTableInfo(DbTableInfo dbTableInfo, TableInfo tableInfo) {
        tableInfo.setTableName(dbTableInfo.getTableName());
        tableInfo.setTableSchema(dbTableInfo.getTableSchema());
        if (GeneratorStringUtils.isBlank(tableInfo.getTableComment())) {
            tableInfo.setTableComment("TODO");
        } else {
            tableInfo.setTableComment(dbTableInfo.getTableComment());
        }
        List<ColumnInfo> columnLists = dbTableInfo.getColumnLists();
        for (int i = 0; i < columnLists.size(); ++i) {
            ColumnInfo columnInfo = columnLists.get(i);
            JavaColumnInfo javaColumnInfo = new JavaColumnInfo();
            javaColumnInfo.setDataType(this.getDataType(columnInfo.getDataType()));
            javaColumnInfo.setColumnName(columnInfo.getColumnName());
            javaColumnInfo.setColumnComment(this.replaceEnter(columnInfo.getColumnComment()));
            javaColumnInfo.setJavaColumnName(GeneratorStringUtils.changeColmName2CamelFirstLower(columnInfo.getColumnName(), ConfigConstants.tableRegex));
            javaColumnInfo.setJavaDataType(this.getJavaDataType(columnInfo));
            javaColumnInfo.setColumnJdbcType(TypeConversion.type2JdbcType(columnInfo.getDataType()));
            javaColumnInfo.setParameterType(TypeConversion.getTypeByMap(TypeConversion.parameterTypeMap, javaColumnInfo.getJavaDataType()));
            javaColumnInfo.setJavaDataTypeFullPath(TypeConversion.javaDataTypeFullPathMap.get(javaColumnInfo.getJavaDataType()));
            tableInfo.addJavaColumnInfo(javaColumnInfo);
            tableInfo.addImportPackage(javaColumnInfo.getJavaDataTypeFullPath());
        }
    }

    protected String getDataType(String dataType) {
        if (GeneratorStringUtils.isNotBlank(dataType) && dataType.contains("TIMESTAMP")) {
            return "TIMESTAMP";
        }
        return dataType;
    }

    protected abstract String getJavaDataType(ColumnInfo var1);

    protected String replaceEnter(String columnComment) {
        if (GeneratorStringUtils.isBlank(columnComment)) {
            return "";
        }
        return columnComment.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\r\n", " ");
    }

    protected String getJavaTableName(String tableName) {
        return GeneratorStringUtils.changeTableName2CamelFirstUpper(tableName, ConfigConstants.tableRegex);
    }
}

