/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.convention;

import com.github.zhuyizhuo.generator.mybatis.constants.ConfigConstants;
import com.github.zhuyizhuo.generator.mybatis.extension.service.FormatService;
import com.github.zhuyizhuo.generator.mybatis.vo.TableInfo;
import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.PropertiesUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class StratificationInfo {
    private static final String point = ".";
    private String basePackage = "";
    private String POJO_NAME_FORMAT = "{0}";
    private String DAO_NAME_FORMAT = "{0}Mapper";
    private String daoPackage = "dao";
    private String pojoPackage = "pojo";
    private String xmlPackage = "xml";
    private String pojoName;
    private String daoName;
    private String xmlName;
    private String daoFullPackage;
    private String pojoFullPackage;
    private String xmlFullPackage;
    private Map<String, FormatService> nameFormatMap = new HashMap<String, FormatService>();
    private FormatService formatService = new FormatService(){

        @Override
        public String formatTableName(String tableName) {
            return tableName.toLowerCase();
        }
    };
    private String SERVICE_NAME_FORMAT = "{0}Service";
    private String SERVICE_IMPL_NAME_FORMAT = "{0}ServiceImpl";
    private String servicePackage = "service";
    private String serviceImplPackage = "service.impl";
    private String serviceName;
    private String serviceImplName;
    private String serviceFullPackage;
    private String serviceImplFullPackage;

    public StratificationInfo() {
    }

    public StratificationInfo(String basePackage) {
        this.init(basePackage);
    }

    public void init() {
        this.init(PropertiesUtils.getProperties("BASE_PACKAGE"));
    }

    public void init(String basePackage) {
        this.initEachFormat();
        this.initEachPackage();
        if (GeneratorStringUtils.isNotBlank(basePackage)) {
            this.basePackage = basePackage;
            basePackage = basePackage + point;
        } else {
            basePackage = "";
        }
        this.daoFullPackage = basePackage + this.daoPackage;
        this.serviceFullPackage = basePackage + this.servicePackage;
        this.serviceImplFullPackage = basePackage + this.serviceImplPackage;
        this.pojoFullPackage = basePackage + this.pojoPackage;
        this.xmlFullPackage = basePackage + this.xmlPackage;
    }

    private void initEachPackage() {
        String pojoPackage = PropertiesUtils.getProperties("POJO_PACKAGE");
        String daoPackage = PropertiesUtils.getProperties("DAO_PACKAGE");
        String xmlPackage = PropertiesUtils.getProperties("XML_PACKAGE");
        if (GeneratorStringUtils.isNotBlank(pojoPackage)) {
            this.pojoPackage = pojoPackage;
        }
        if (GeneratorStringUtils.isNotBlank(daoPackage)) {
            this.daoPackage = daoPackage;
        }
        if (GeneratorStringUtils.isNotBlank(xmlPackage)) {
            this.xmlPackage = xmlPackage;
        }
    }

    private void initEachFormat() {
        String daoNameFormat = PropertiesUtils.getProperties("DAO_NAME_FORMAT");
        String serviceImplNameFormat = PropertiesUtils.getProperties("SERVICE_IMPL_NAME_FORMAT");
        String serviceNameFormat = PropertiesUtils.getProperties("SERVICE_NAME_FORMAT");
        String pojoNameFormat = PropertiesUtils.getProperties("POJO_NAME_FORMAT");
        if (GeneratorStringUtils.isNotBlank(daoNameFormat)) {
            this.DAO_NAME_FORMAT = daoNameFormat;
        }
        if (GeneratorStringUtils.isNotBlank(serviceImplNameFormat)) {
            this.SERVICE_IMPL_NAME_FORMAT = serviceImplNameFormat;
        }
        if (GeneratorStringUtils.isNotBlank(serviceNameFormat)) {
            this.SERVICE_NAME_FORMAT = serviceNameFormat;
        }
        if (GeneratorStringUtils.isNotBlank(pojoNameFormat)) {
            this.POJO_NAME_FORMAT = pojoNameFormat;
        }
    }

    public static String getPoint() {
        return point;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getDaoPackage() {
        return this.daoPackage;
    }

    public void setDaoPackage(String daoPackage) {
        this.daoPackage = daoPackage;
    }

    public String getServicePackage() {
        return this.servicePackage;
    }

    public void setServicePackage(String servicePackage) {
        this.servicePackage = servicePackage;
    }

    public String getServiceImplPackage() {
        return this.serviceImplPackage;
    }

    public void setServiceImplPackage(String serviceImplPackage) {
        this.serviceImplPackage = serviceImplPackage;
    }

    public String getPojoPackage() {
        return this.pojoPackage;
    }

    public void setPojoPackage(String pojoPackage) {
        this.pojoPackage = pojoPackage;
    }

    public String getXmlPackage() {
        return this.xmlPackage;
    }

    public void setXmlPackage(String xmlPackage) {
        this.xmlPackage = xmlPackage;
    }

    public String getPojoName() {
        return this.pojoName;
    }

    public void setPojoName(String tableName) {
        this.pojoName = this.nameFormatMap.get("POJO_NAME_FORMAT") != null ? this.nameFormatMap.get("POJO_NAME_FORMAT").formatTableName(tableName) : this.formatName(this.POJO_NAME_FORMAT, GeneratorStringUtils.changeTableName2CamelFirstUpper(tableName, ConfigConstants.tableRegex));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.formatName(this.SERVICE_NAME_FORMAT, serviceName);
    }

    public String getServiceImplName() {
        return this.serviceImplName;
    }

    public void setServiceImplName(String serviceImplName) {
        this.serviceImplName = this.formatName(this.SERVICE_IMPL_NAME_FORMAT, serviceImplName);
    }

    public String getDaoName() {
        return this.daoName;
    }

    public void setDaoName(String tableName) {
        this.daoName = this.nameFormatMap.get("DAO_NAME_FORMAT") != null ? this.nameFormatMap.get("DAO_NAME_FORMAT").formatTableName(tableName) : this.formatName(this.DAO_NAME_FORMAT, GeneratorStringUtils.changeTableName2CamelFirstUpper(tableName, ConfigConstants.tableRegex));
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public String getDaoFullPackage() {
        return this.daoFullPackage;
    }

    public void setDaoFullPackage(String daoFullPackage) {
        this.daoFullPackage = daoFullPackage;
    }

    public String getServiceFullPackage() {
        return this.serviceFullPackage;
    }

    public void setServiceFullPackage(String serviceFullPackage) {
        this.serviceFullPackage = serviceFullPackage;
    }

    public String getServiceImplFullPackage() {
        return this.serviceImplFullPackage;
    }

    public void setServiceImplFullPackage(String serviceImplFullPackage) {
        this.serviceImplFullPackage = serviceImplFullPackage;
    }

    public String getPojoFullPackage() {
        return this.pojoFullPackage;
    }

    public void setPojoFullPackage(String pojoFullPackage) {
        this.pojoFullPackage = pojoFullPackage;
    }

    public String getXmlFullPackage() {
        return this.xmlFullPackage;
    }

    public void setXmlFullPackage(String xmlFullPackage) {
        this.xmlFullPackage = xmlFullPackage;
    }

    private void initXmlName(TableInfo tableInfo) {
        String xmlNameFormat = PropertiesUtils.getProperties("XML_NAME_FORMAT");
        if ("camel".equalsIgnoreCase(xmlNameFormat)) {
            this.setXmlName(tableInfo.getJavaTableName());
        } else {
            this.setXmlName(this.formatService.formatTableName(tableInfo.getTableName()));
        }
    }

    public String formatName(String format, String javaTableName) {
        return MessageFormat.format(format, javaTableName);
    }

    public void addXmlNameFormat(FormatService formatService) {
        this.formatService = formatService;
    }

    public void initFilesName(TableInfo tableInfo) {
        String javaTableName = tableInfo.getJavaTableName();
        this.setPojoName(tableInfo.getTableName());
        this.setDaoName(tableInfo.getTableName());
        this.setServiceName(javaTableName);
        this.setServiceImplName(javaTableName);
        this.initXmlName(tableInfo);
    }

    private void addFormatService(FormatService formatService, String pojoNameFormat) {
        this.nameFormatMap.put(pojoNameFormat, formatService);
    }

    public void addBeanNameFormat(FormatService formatService) {
        this.addFormatService(formatService, "POJO_NAME_FORMAT");
    }

    public void addDaoNameFormat(FormatService formatService) {
        this.addFormatService(formatService, "DAO_NAME_FORMAT");
    }
}

