/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhuyizhuo.generator.mybatis.convention;

import com.github.zhuyizhuo.generator.mybatis.convention.StratificationInfo;
import com.github.zhuyizhuo.generator.utils.GeneratorStringUtils;
import com.github.zhuyizhuo.generator.utils.PropertiesUtils;
import java.text.MessageFormat;

public class FileOutPathInfo {
    private String basePath;
    private String pojoOutPutPath;
    private String daoOutPutPath;
    private String xmlOutPutPath;
    private String pojoOutPutFullPath;
    private String daoOutPutFullPath;
    private String xmlOutPutFullPath;

    public String initBasePath() {
        this.basePath = PropertiesUtils.getProperties("FILE_OUT_PUT_PATH");
        if (GeneratorStringUtils.isBlank(this.basePath)) {
            this.basePath = System.getProperty("user.dir") + "/src/main/java/";
        }
        this.basePath = this.basePath + "/";
        return this.basePath;
    }

    public void init(StratificationInfo stratificationInfo) {
        this.initBasePath();
        if (PropertiesUtils.containsKey("XML_OUT_PUT_PATH")) {
            this.setXmlOutPutPath(PropertiesUtils.getProperties("XML_OUT_PUT_PATH"));
        }
        if (PropertiesUtils.containsKey("DAO_OUT_PUT_PATH")) {
            this.setDaoOutPutPath(PropertiesUtils.getProperties("DAO_OUT_PUT_PATH"));
        }
        if (PropertiesUtils.containsKey("POJO_OUT_PUT_PATH")) {
            this.setPojoOutPutPath(PropertiesUtils.getProperties("POJO_OUT_PUT_PATH"));
        }
        this.pojoOutPutPath = GeneratorStringUtils.isBlank(this.pojoOutPutPath) ? this.getJavaFileOutPutFullPath(this.changePackage2Path(stratificationInfo.getPojoFullPackage())) : this.getJavaFileOutPutFullPath(this.pojoOutPutPath);
        this.daoOutPutPath = GeneratorStringUtils.isBlank(this.daoOutPutPath) ? this.getJavaFileOutPutFullPath(this.changePackage2Path(stratificationInfo.getDaoFullPackage())) : this.getJavaFileOutPutFullPath(this.daoOutPutPath);
        this.xmlOutPutPath = GeneratorStringUtils.isBlank(this.xmlOutPutPath) ? this.getXmlOutPutPath(this.changePackage2Path(stratificationInfo.getXmlFullPackage())) : this.getXmlOutPutPath(this.xmlOutPutPath);
    }

    public void formatPath(StratificationInfo stratificationInfo) {
        this.pojoOutPutFullPath = MessageFormat.format(this.pojoOutPutPath, stratificationInfo.getPojoName());
        this.daoOutPutFullPath = MessageFormat.format(this.daoOutPutPath, stratificationInfo.getDaoName());
        this.xmlOutPutFullPath = MessageFormat.format(this.xmlOutPutPath, stratificationInfo.getXmlName());
    }

    private String getJavaFileOutPutFullPath(String filePath) {
        return this.basePath + filePath + "/{0}.java";
    }

    private String getXmlOutPutPath(String xmlFilePath) {
        return this.basePath + xmlFilePath + "/{0}.xml";
    }

    public String changePackage2Path(String packagePath) {
        return packagePath.replaceAll("\\.", "/");
    }

    public String getPojoOutPutPath() {
        return this.pojoOutPutPath;
    }

    public void setPojoOutPutPath(String pojoOutPutPath) {
        this.pojoOutPutPath = pojoOutPutPath;
    }

    public String getDaoOutPutPath() {
        return this.daoOutPutPath;
    }

    public void setDaoOutPutPath(String daoOutPutPath) {
        this.daoOutPutPath = daoOutPutPath;
    }

    public String getXmlOutPutPath() {
        return this.xmlOutPutPath;
    }

    public void setXmlOutPutPath(String xmlOutPutPath) {
        this.xmlOutPutPath = xmlOutPutPath;
    }

    public String getPojoOutPutFullPath() {
        return this.pojoOutPutFullPath;
    }

    public void setPojoOutPutFullPath(String pojoOutPutFullPath) {
        this.pojoOutPutFullPath = pojoOutPutFullPath;
    }

    public String getDaoOutPutFullPath() {
        return this.daoOutPutFullPath;
    }

    public void setDaoOutPutFullPath(String daoOutPutFullPath) {
        this.daoOutPutFullPath = daoOutPutFullPath;
    }

    public String getXmlOutPutFullPath() {
        return this.xmlOutPutFullPath;
    }

    public void setXmlOutPutFullPath(String xmlOutPutFullPath) {
        this.xmlOutPutFullPath = xmlOutPutFullPath;
    }
}

