/*
 * Decompiled with CFR 0.152.
 */
package com.Albert.cache;

import com.Albert.cache.Compute;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;

public class EfficientCacheCompute<KeyT, ResultT>
implements Compute<KeyT, ResultT> {
    private final boolean IS_NOT_RETURN = true;
    private final ConcurrentHashMap<KeyT, Future<ResultT>> cacheResult;
    private final Function<KeyT, ResultT> computeMethod;

    private EfficientCacheCompute(Function<KeyT, ResultT> computeMethod) {
        this.computeMethod = computeMethod;
        this.cacheResult = new ConcurrentHashMap();
    }

    public static <KeyT, ResultT> EfficientCacheCompute createNeedComputeFunction(Function<KeyT, ResultT> computeMethod) {
        return new EfficientCacheCompute<KeyT, ResultT>(computeMethod);
    }

    @Override
    public ResultT compute(KeyT keyT) {
        Callable<Object> computeMethodHavingPutKey;
        FutureTask<Object> runWhenResultFutureNull;
        FutureTask<Object> resultFuture = this.cacheResult.get(keyT);
        if (this.isNotExitResult(resultFuture) && this.isNotExitResult(resultFuture = (FutureTask<Object>)this.cacheResult.putIfAbsent(keyT, runWhenResultFutureNull = new FutureTask<Object>(computeMethodHavingPutKey = () -> this.computeMethod.apply(keyT))))) {
            resultFuture = runWhenResultFutureNull;
            runWhenResultFutureNull.run();
        }
        return this.getResultWithTryCatch(resultFuture);
    }

    private boolean isNotExitResult(Future<ResultT> resultFuture) {
        return resultFuture == null;
    }

    private ResultT getResultWithTryCatch(Future<ResultT> resultTFuture) {
        ResultT resultT = null;
        try {
            resultT = resultTFuture.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return resultT;
    }

    @Override
    public ResultT getCacheIfExist(KeyT key) {
        Future<ResultT> resultTFuture = this.cacheResult.get(key);
        ResultT result = null;
        if (this.isExistResult(resultTFuture)) {
            result = this.getResultWithTryCatch(resultTFuture);
        }
        return result;
    }

    private boolean isExistResult(Future<ResultT> resultTFuture) {
        return resultTFuture != null;
    }

    @Override
    public ConcurrentHashMap.KeySetView<KeyT, Future<ResultT>> getKeySetFromCacheResult() {
        return this.cacheResult.keySet();
    }

    @Override
    public void clearCache() {
        this.cacheResult.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheResult.isEmpty();
    }
}

