/*
 * Decompiled with CFR 0.152.
 */
package com.Albert.cache;

import com.Albert.cache.Compute;
import com.Albert.cache.EfficientCacheCompute;
import java.util.function.Function;

public class App {
    public static void main(String[] args) {
        EfficientCacheCompute compute = EfficientCacheCompute.createNeedComputeFunction(App.get_A_TestComputeMethod());
        System.out.println("--------start the first task of many compute--------");
        long firstCostTime = App.getComputeTime(compute);
        System.out.println("This is not use cache time: " + firstCostTime + " ns");
        System.out.println("--------start the second task of many compute--------");
        long secondCostTime = App.getComputeTime(compute);
        System.out.println("This is use cache time: " + secondCostTime + " ns");
    }

    private static Function<Long, Long> get_A_TestComputeMethod() {
        return a -> {
            long result = 0L;
            for (long i = 1L; i <= a; ++i) {
                result += i;
            }
            return result;
        };
    }

    private static long getComputeTime(Compute compute) {
        long startTime = System.nanoTime();
        App.toComputeVeryMuch(compute);
        long endTime = System.nanoTime();
        return endTime - startTime;
    }

    private static void toComputeVeryMuch(Compute compute) {
        long computeFromOneUntilThis = 100000L;
        for (long i = 1L; i <= computeFromOneUntilThis; ++i) {
            compute.compute(i);
        }
    }
}

