/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.mongodb;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.ConfigurationAwareModule;
import com.github.zhengframework.configuration.ConfigurationBeanMapper;
import com.github.zhengframework.mongodb.MongoClientProvider;
import com.github.zhengframework.mongodb.MongodbConfig;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.mongodb.client.MongoClient;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Provider;

public class MongodbModule
extends ConfigurationAwareModule {
    protected void configure() {
        Map mongodbConfigMap = ConfigurationBeanMapper.resolve((Configuration)this.getConfiguration(), MongodbConfig.class);
        for (Map.Entry entry : mongodbConfigMap.entrySet()) {
            if (((String)entry.getKey()).isEmpty()) {
                MongodbConfig mongodbConfig = (MongodbConfig)entry.getValue();
                this.bind(MongodbConfig.class).toInstance((Object)mongodbConfig);
                this.bind(MongoClient.class).toProvider(MongoClientProvider.class);
                continue;
            }
            String name = (String)entry.getKey();
            MongodbConfig mongodbConfig = (MongodbConfig)entry.getValue();
            this.bind(Key.get(MongodbConfig.class, (Annotation)Names.named((String)name))).toInstance((Object)mongodbConfig);
            this.bind(Key.get(MongoClient.class, (Annotation)Names.named((String)name))).toProvider((Provider)new MongoClientProvider(mongodbConfig));
        }
    }
}

