/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration.source;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.zhengframework.configuration.environment.Environment;
import com.github.zhengframework.configuration.source.ConfigurationSource;
import com.github.zhengframework.configuration.source.ConfigurationSourceListener;
import java.util.Map;
import java.util.Objects;

public class MeteredConfigurationSource
implements ConfigurationSource {
    private final ConfigurationSource delegate;
    private final Timer getConfigurationTimer;
    private final Timer initTimer;

    public MeteredConfigurationSource(MetricRegistry metricRegistry, String metricPrefix, ConfigurationSource delegate) {
        Objects.requireNonNull(metricRegistry);
        Objects.requireNonNull(metricPrefix);
        this.delegate = Objects.requireNonNull(delegate);
        this.getConfigurationTimer = metricRegistry.timer(metricPrefix + "source.getConfiguration");
        this.initTimer = metricRegistry.timer(metricPrefix + "source.init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfiguration(Environment environment) {
        Timer.Context context = this.getConfigurationTimer.time();
        try {
            Map map = this.delegate.getConfiguration(environment);
            return map;
        }
        finally {
            context.stop();
        }
    }

    public void init() {
        Timer.Context context = this.initTimer.time();
        try {
            this.delegate.init();
        }
        finally {
            context.stop();
        }
    }

    public void addListener(ConfigurationSourceListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(ConfigurationSourceListener listener) {
        this.delegate.removeListener(listener);
    }
}

