/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration.reload;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.zhengframework.configuration.reload.Reloadable;
import java.util.Objects;

public class MeteredReloadable
implements Reloadable {
    private final Reloadable delegate;
    private final Timer reloadTimer;

    public MeteredReloadable(MetricRegistry metricRegistry, String metricPrefix, Reloadable delegate) {
        Objects.requireNonNull(metricRegistry);
        Objects.requireNonNull(metricPrefix);
        this.delegate = Objects.requireNonNull(delegate);
        this.reloadTimer = metricRegistry.timer(metricPrefix + "reloadable.reload");
    }

    public void reload() {
        Timer.Context context = this.reloadTimer.time();
        try {
            this.delegate.reload();
        }
        finally {
            context.stop();
        }
    }
}

