/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.codahale.metrics.MetricRegistry;
import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.MeteredConfiguration;
import com.github.zhengframework.configuration.SourceBasedConfiguration;
import com.github.zhengframework.configuration.environment.DefaultEnvironment;
import com.github.zhengframework.configuration.environment.Environment;
import com.github.zhengframework.configuration.reload.CachedConfigurationSource;
import com.github.zhengframework.configuration.reload.ImmediateReloadStrategy;
import com.github.zhengframework.configuration.reload.MeteredReloadable;
import com.github.zhengframework.configuration.reload.ReloadStrategy;
import com.github.zhengframework.configuration.reload.Reloadable;
import com.github.zhengframework.configuration.source.ConfigurationSource;
import com.github.zhengframework.configuration.source.EmptyConfigurationSource;
import com.github.zhengframework.configuration.source.MeteredConfigurationSource;
import java.util.Objects;

public class MetricsConfigurationBuilder {
    private ConfigurationSource configurationSource = new EmptyConfigurationSource();
    private ReloadStrategy reloadStrategy = new ImmediateReloadStrategy();
    private Environment environment = new DefaultEnvironment();
    private MetricRegistry metricRegistry;
    private String prefix = "";

    public static MetricsConfigurationBuilder builder() {
        return new MetricsConfigurationBuilder();
    }

    public MetricsConfigurationBuilder withConfigurationSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
        return this;
    }

    public MetricsConfigurationBuilder withReloadStrategy(ReloadStrategy reloadStrategy) {
        this.reloadStrategy = reloadStrategy;
        return this;
    }

    public MetricsConfigurationBuilder withEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public MetricsConfigurationBuilder withMetrics(MetricRegistry metricRegistry, String prefix) {
        this.prefix = Objects.requireNonNull(prefix);
        this.metricRegistry = metricRegistry;
        return this;
    }

    public Configuration build() {
        CachedConfigurationSource cachedConfigurationSource = new CachedConfigurationSource(this.configurationSource);
        if (this.metricRegistry != null) {
            this.configurationSource = new MeteredConfigurationSource(this.metricRegistry, this.prefix, (ConfigurationSource)cachedConfigurationSource);
        }
        cachedConfigurationSource.init();
        Reloadable reloadable = () -> cachedConfigurationSource.reload(this.environment);
        if (this.metricRegistry != null) {
            reloadable = new MeteredReloadable(this.metricRegistry, this.prefix, reloadable);
        }
        reloadable.reload();
        this.reloadStrategy.register(reloadable);
        SourceBasedConfiguration configuration = new SourceBasedConfiguration((ConfigurationSource)cachedConfigurationSource, this.environment);
        if (this.metricRegistry != null) {
            return new MeteredConfiguration(this.metricRegistry, this.prefix, (Configuration)configuration);
        }
        return configuration;
    }
}

