/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.zhengframework.configuration.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MeteredConfiguration
implements Configuration {
    private final Configuration delegate;
    private final Timer getTimer;
    private final Timer keySetTimer;
    private final Timer asMapTimer;
    private final Timer prefixTimer;
    private final Timer prefixSetTimer;
    private final Timer prefixMapTimer;

    public MeteredConfiguration(MetricRegistry metricRegistry, String metricPrefix, Configuration delegate) {
        Objects.requireNonNull(metricRegistry);
        Objects.requireNonNull(metricPrefix);
        this.delegate = Objects.requireNonNull(delegate);
        this.getTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.get"}));
        this.keySetTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.keySet"}));
        this.asMapTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.asMap"}));
        this.prefixTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.prefix"}));
        this.prefixSetTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.prefixSet"}));
        this.prefixMapTimer = metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"configuration.prefixMap"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> get(String key) {
        Throwable throwable = null;
        try (Timer.Context context = this.getTimer.time();){
            Optional optional;
            try {
                optional = this.delegate.get(key);
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Throwable throwable = null;
        try (Timer.Context context = this.keySetTimer.time();){
            Set set;
            try {
                set = this.delegate.keySet();
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> asMap() {
        Throwable throwable = null;
        try (Timer.Context context = this.asMapTimer.time();){
            Map map;
            try {
                map = this.delegate.asMap();
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration prefix(String prefix) {
        Throwable throwable = null;
        try (Timer.Context context = this.prefixTimer.time();){
            Configuration configuration;
            try {
                configuration = this.delegate.prefix(prefix);
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Configuration> prefixList(String prefix) {
        Throwable throwable = null;
        try (Timer.Context context = this.prefixSetTimer.time();){
            List list;
            try {
                list = this.delegate.prefixList(prefix);
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Configuration> prefixSet(String prefix) {
        Throwable throwable = null;
        try (Timer.Context context = this.prefixSetTimer.time();){
            Set set;
            try {
                set = this.delegate.prefixSet(prefix);
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Configuration> prefixMap(String prefix) {
        Throwable throwable = null;
        try (Timer.Context context = this.prefixMapTimer.time();){
            Map map;
            try {
                map = this.delegate.prefixMap(prefix);
            }
            catch (Throwable throwable2) {
                try {
                    context.stop();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            context.stop();
            return map;
        }
    }
}

