/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.anran.common.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import me.zhangchunsheng.anran.common.bean.AnranApiData;
import me.zhangchunsheng.anran.common.config.AnranConfig;
import me.zhangchunsheng.anran.common.service.AnranService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceImpl
implements AnranService {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    static ThreadLocal<AnranApiData> anranApiData = new ThreadLocal();
    protected AnranConfig config;

    @Override
    public AnranConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(AnranConfig config) {
        this.config = config;
    }

    @Override
    public String getBaseUrl() {
        return this.getConfig().getBaseUrl();
    }

    @Override
    public String getEnergyBaseUrl() {
        return this.getConfig().getEnergyBaseUrl();
    }

    public static String getUrlParams(Map<String, Object> source) {
        Iterator<String> it = source.keySet().iterator();
        StringBuilder paramStr = new StringBuilder();
        while (it.hasNext()) {
            String key = it.next();
            String value = source.get(key).toString();
            if (value.isEmpty()) continue;
            try {
                value = URLEncoder.encode(value, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            paramStr.append("&").append(key).append("=").append(value);
        }
        return paramStr.substring(1);
    }
}

