/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.anran.common.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import jodd.util.Base64;
import me.zhangchunsheng.anran.common.bean.AnranApiData;
import me.zhangchunsheng.anran.common.exception.AnranException;
import me.zhangchunsheng.anran.common.service.impl.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class AnranServiceJoddHttpImpl
extends BaseServiceImpl {
    @Override
    public byte[] postForBytes(String url, String requestStr) throws AnranException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            byte[] responseBytes = request.send().bodyBytes();
            String responseString = Base64.encodeToString((byte[])responseBytes);
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e(Base64\u7f16\u7801\u540e)\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                anranApiData.set(new AnranApiData(url, requestStr, responseString, null));
            }
            return responseBytes;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            anranApiData.set(new AnranApiData(url, requestStr, null, e.getMessage()));
            throw new AnranException(e.getMessage(), e);
        }
    }

    @Override
    public String post(String url, String requestStr) throws AnranException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                anranApiData.set(new AnranApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            anranApiData.set(new AnranApiData(url, requestStr, null, e.getMessage()));
            throw new AnranException(e.getMessage(), e);
        }
    }

    @Override
    public String post(String url, Map<String, Object> params) throws AnranException {
        String requestStr = AnranServiceJoddHttpImpl.getUrlParams(params);
        return this.post(url, requestStr);
    }

    @Override
    public String postJson(String url, String requestStr) throws AnranException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                anranApiData.set(new AnranApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            anranApiData.set(new AnranApiData(url, requestStr, null, e.getMessage()));
            throw new AnranException(e.getMessage(), e);
        }
    }

    @Override
    public String postJson(String url, String csrfToken, String session, String requestStr) throws AnranException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                anranApiData.set(new AnranApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            anranApiData.set(new AnranApiData(url, requestStr, null, e.getMessage()));
            throw new AnranException(e.getMessage(), e);
        }
    }

    @Override
    public String get(String url) throws AnranException {
        try {
            HttpRequest request = this.buildHttpGet(url);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, "", responseString});
            if (this.getConfig().isIfSaveApiData()) {
                anranApiData.set(new AnranApiData(url, "", responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, "", e.getMessage()});
            anranApiData.set(new AnranApiData(url, "", null, e.getMessage()));
            throw new AnranException(e.getMessage(), e);
        }
    }

    private HttpRequest buildHttpRequest(String url, String requestStr) throws AnranException {
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout()).bodyText(requestStr);
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue(), this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword());
            HttpConnectionProvider provider = request.connectionProvider();
            if (null == provider) {
                provider = new SocketHttpConnectionProvider();
            }
            provider.useProxy(httpProxy);
            request.withConnectionProvider(provider);
        }
        return request;
    }

    private HttpRequest buildHttpGet(String url) throws AnranException {
        HttpRequest request = HttpRequest.get((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout());
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue(), this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword());
            HttpConnectionProvider provider = request.connectionProvider();
            if (null == provider) {
                provider = new SocketHttpConnectionProvider();
            }
            provider.useProxy(httpProxy);
            request.withConnectionProvider(provider);
        }
        return request;
    }

    private String getResponseString(HttpResponse response) throws AnranException {
        try {
            this.log.debug("\u3010\u795e\u5dde\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        }
        catch (NullPointerException e) {
            this.log.warn("HttpResponse.toString() \u5c45\u7136\u629b\u51fa\u7a7a\u6307\u9488\u5f02\u5e38\u4e86", (Throwable)e);
        }
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)responseString)) {
            throw new AnranException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            responseString = new String(responseString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return responseString;
    }
}

