/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.anran.common.exception;

import com.google.common.base.Joiner;
import me.zhangchunsheng.anran.common.bean.result.BaseAnranResult;

public class AnranException
extends Exception {
    private static final long serialVersionUID = 2020381471513460742L;
    private String customErrorMsg;
    private String returnStatus;
    private String returnMsg;
    private int returnCode;

    public AnranException(String customErrorMsg) {
        super(customErrorMsg);
        this.customErrorMsg = customErrorMsg;
    }

    public AnranException(String customErrorMsg, Throwable tr) {
        super(customErrorMsg, tr);
        this.customErrorMsg = customErrorMsg;
    }

    private AnranException(Builder builder) {
        super(builder.buildErrorMsg());
        this.returnStatus = builder.returnStatus;
        this.returnMsg = builder.returnMsg;
        this.returnCode = builder.returnCode;
    }

    public static AnranException from(BaseAnranResult baseResult) {
        return AnranException.newBuilder().returnStatus(baseResult.isSuccess() ? "1" : "0").returnMsg(baseResult.getErrmsg()).returnCode(baseResult.getErrcode()).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCustomErrorMsg() {
        return this.customErrorMsg;
    }

    public String getReturnStatus() {
        return this.returnStatus;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setCustomErrorMsg(String customErrorMsg) {
        this.customErrorMsg = customErrorMsg;
    }

    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    @Override
    public String toString() {
        return "AnranException(customErrorMsg=" + this.getCustomErrorMsg() + ", returnStatus=" + this.getReturnStatus() + ", returnMsg=" + this.getReturnMsg() + ", returnCode=" + this.getReturnCode() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnranException)) {
            return false;
        }
        AnranException other = (AnranException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customErrorMsg = this.getCustomErrorMsg();
        String other$customErrorMsg = other.getCustomErrorMsg();
        if (this$customErrorMsg == null ? other$customErrorMsg != null : !this$customErrorMsg.equals(other$customErrorMsg)) {
            return false;
        }
        String this$returnStatus = this.getReturnStatus();
        String other$returnStatus = other.getReturnStatus();
        if (this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus)) {
            return false;
        }
        String this$returnMsg = this.getReturnMsg();
        String other$returnMsg = other.getReturnMsg();
        if (this$returnMsg == null ? other$returnMsg != null : !this$returnMsg.equals(other$returnMsg)) {
            return false;
        }
        return this.getReturnCode() == other.getReturnCode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnranException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customErrorMsg = this.getCustomErrorMsg();
        result = result * 59 + ($customErrorMsg == null ? 43 : $customErrorMsg.hashCode());
        String $returnStatus = this.getReturnStatus();
        result = result * 59 + ($returnStatus == null ? 43 : $returnStatus.hashCode());
        String $returnMsg = this.getReturnMsg();
        result = result * 59 + ($returnMsg == null ? 43 : $returnMsg.hashCode());
        result = result * 59 + this.getReturnCode();
        return result;
    }

    public static final class Builder {
        private String returnStatus;
        private String returnMsg;
        private int returnCode;

        private Builder() {
        }

        public Builder returnStatus(String returnStatus) {
            this.returnStatus = returnStatus;
            return this;
        }

        public Builder returnMsg(String returnMsg) {
            this.returnMsg = returnMsg;
            return this;
        }

        public Builder returnCode(int returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public AnranException build() {
            return new AnranException(this);
        }

        public String buildErrorMsg() {
            return Joiner.on((String)"\uff0c").skipNulls().join((Object)(this.returnStatus == null ? null : String.format("\u8fd4\u56de\u4ee3\u7801\uff1a[%s]", this.returnStatus)), (Object)(this.returnMsg == null ? null : String.format("\u8fd4\u56de\u4fe1\u606f\uff1a[%s]", this.returnMsg)), new Object[]{String.format("\u7ed3\u679c\u4ee3\u7801\uff1a[%s]", this.returnCode)});
        }
    }
}

