/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.amap.common.util.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;

public class XStreamInitializer {
    private static final XppDriver XPP_DRIVER = new XppDriver(){

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out, this.getNameCoder()){
                private static final String PREFIX_CDATA = "<![CDATA[";
                private static final String SUFFIX_CDATA = "]]>";
                private static final String PREFIX_MEDIA_ID = "<MediaId>";
                private static final String SUFFIX_MEDIA_ID = "</MediaId>";

                protected void writeText(QuickWriter writer, String text) {
                    if (text.startsWith(PREFIX_CDATA) && text.endsWith(SUFFIX_CDATA)) {
                        writer.write(text);
                    } else if (text.startsWith(PREFIX_MEDIA_ID) && text.endsWith(SUFFIX_MEDIA_ID)) {
                        writer.write(text);
                    } else {
                        super.writeText(writer, text);
                    }
                }

                public String encodeNode(String name) {
                    return name;
                }
            };
        }
    };

    public static XStream getInstance() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)XPP_DRIVER);
        xstream.ignoreUnknownElements();
        xstream.setMode(1001);
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.allowTypesByWildcard(new String[]{"me.zhangchunsheng.amap.common.**", "cn.zhangchunsheng.amap.**", "com.github.zhangchunsheng.**"});
        xstream.setClassLoader(Thread.currentThread().getContextClassLoader());
        return xstream;
    }
}

