/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.amap.common.service.impl;

import java.nio.charset.StandardCharsets;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import jodd.util.Base64;
import me.zhangchunsheng.amap.common.bean.AmapApiData;
import me.zhangchunsheng.amap.common.exception.AmapException;
import me.zhangchunsheng.amap.common.service.impl.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class AmapServiceJoddHttpImpl
extends BaseServiceImpl {
    @Override
    public byte[] postForBytes(String url, String requestStr) throws AmapException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            byte[] responseBytes = request.send().bodyBytes();
            String responseString = Base64.encodeToString((byte[])responseBytes);
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e(Base64\u7f16\u7801\u540e)\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                amapApiData.set(new AmapApiData(url, requestStr, responseString, null));
            }
            return responseBytes;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            amapApiData.set(new AmapApiData(url, requestStr, null, e.getMessage()));
            throw new AmapException(e.getMessage(), e);
        }
    }

    @Override
    public String post(String url, String requestStr) throws AmapException {
        try {
            HttpRequest request = this.buildHttpRequest(url, requestStr);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                amapApiData.set(new AmapApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            amapApiData.set(new AmapApiData(url, requestStr, null, e.getMessage()));
            throw new AmapException(e.getMessage(), e);
        }
    }

    @Override
    public String get(String url) throws AmapException {
        try {
            HttpRequest request = this.buildHttpGet(url);
            String responseString = this.getResponseString(request.send());
            this.log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, "", responseString});
            if (this.getConfig().isIfSaveApiData()) {
                amapApiData.set(new AmapApiData(url, "", responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, "", e.getMessage()});
            amapApiData.set(new AmapApiData(url, "", null, e.getMessage()));
            throw new AmapException(e.getMessage(), e);
        }
    }

    private HttpRequest buildHttpRequest(String url, String requestStr) throws AmapException {
        HttpRequest request = (HttpRequest)HttpRequest.post((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout()).bodyText(requestStr);
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue(), this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword());
            HttpConnectionProvider provider = request.connectionProvider();
            if (null == provider) {
                provider = new SocketHttpConnectionProvider();
            }
            provider.useProxy(httpProxy);
            request.withConnectionProvider(provider);
        }
        return request;
    }

    private HttpRequest buildHttpGet(String url) throws AmapException {
        HttpRequest request = HttpRequest.get((String)url).timeout(this.getConfig().getHttpTimeout()).connectionTimeout(this.getConfig().getHttpConnectionTimeout());
        if (StringUtils.isNotBlank((CharSequence)this.getConfig().getHttpProxyHost()) && this.getConfig().getHttpProxyPort() > 0) {
            if (StringUtils.isEmpty((CharSequence)this.getConfig().getHttpProxyUsername())) {
                this.getConfig().setHttpProxyUsername("whatever");
            }
            ProxyInfo httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, this.getConfig().getHttpProxyHost(), this.getConfig().getHttpProxyPort().intValue(), this.getConfig().getHttpProxyUsername(), this.getConfig().getHttpProxyPassword());
            HttpConnectionProvider provider = request.connectionProvider();
            if (null == provider) {
                provider = new SocketHttpConnectionProvider();
            }
            provider.useProxy(httpProxy);
            request.withConnectionProvider(provider);
        }
        return request;
    }

    private String getResponseString(HttpResponse response) throws AmapException {
        try {
            this.log.debug("\u3010\u9ad8\u5fb7\u670d\u52a1\u5668\u54cd\u5e94\u5934\u4fe1\u606f\u3011\uff1a\n{}", (Object)response.toString(false));
        }
        catch (NullPointerException e) {
            this.log.warn("HttpResponse.toString() \u5c45\u7136\u629b\u51fa\u7a7a\u6307\u9488\u5f02\u5e38\u4e86", (Throwable)e);
        }
        String responseString = response.bodyText();
        if (StringUtils.isBlank((CharSequence)responseString)) {
            throw new AmapException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)response.charset())) {
            responseString = new String(responseString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return responseString;
    }
}

