/*
 * Decompiled with CFR 0.152.
 */
package me.zhangchunsheng.amap.common.exception;

import com.google.common.base.Joiner;
import me.zhangchunsheng.amap.common.bean.result.BaseAmapResult;

public class AmapException
extends Exception {
    private static final long serialVersionUID = 2214381471513460742L;
    private String customErrorMsg;
    private String returnStatus;
    private String returnInfo;
    private String returnInfoCode;

    public AmapException(String customErrorMsg) {
        super(customErrorMsg);
        this.customErrorMsg = customErrorMsg;
    }

    public AmapException(String customErrorMsg, Throwable tr) {
        super(customErrorMsg, tr);
        this.customErrorMsg = customErrorMsg;
    }

    private AmapException(Builder builder) {
        super(builder.buildErrorMsg());
        this.returnStatus = builder.returnStatus;
        this.returnInfo = builder.returnInfo;
        this.returnInfoCode = builder.returnInfoCode;
    }

    public static AmapException from(BaseAmapResult baseResult) {
        return AmapException.newBuilder().returnStatus(baseResult.getStatus()).returnInfo(baseResult.getInfo()).returnInfoCode(baseResult.getInfoCode()).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCustomErrorMsg() {
        return this.customErrorMsg;
    }

    public String getReturnStatus() {
        return this.returnStatus;
    }

    public String getReturnInfo() {
        return this.returnInfo;
    }

    public String getReturnInfoCode() {
        return this.returnInfoCode;
    }

    public void setCustomErrorMsg(String customErrorMsg) {
        this.customErrorMsg = customErrorMsg;
    }

    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    public void setReturnInfo(String returnInfo) {
        this.returnInfo = returnInfo;
    }

    public void setReturnInfoCode(String returnInfoCode) {
        this.returnInfoCode = returnInfoCode;
    }

    @Override
    public String toString() {
        return "AmapException(customErrorMsg=" + this.getCustomErrorMsg() + ", returnStatus=" + this.getReturnStatus() + ", returnInfo=" + this.getReturnInfo() + ", returnInfoCode=" + this.getReturnInfoCode() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmapException)) {
            return false;
        }
        AmapException other = (AmapException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customErrorMsg = this.getCustomErrorMsg();
        String other$customErrorMsg = other.getCustomErrorMsg();
        if (this$customErrorMsg == null ? other$customErrorMsg != null : !this$customErrorMsg.equals(other$customErrorMsg)) {
            return false;
        }
        String this$returnStatus = this.getReturnStatus();
        String other$returnStatus = other.getReturnStatus();
        if (this$returnStatus == null ? other$returnStatus != null : !this$returnStatus.equals(other$returnStatus)) {
            return false;
        }
        String this$returnInfo = this.getReturnInfo();
        String other$returnInfo = other.getReturnInfo();
        if (this$returnInfo == null ? other$returnInfo != null : !this$returnInfo.equals(other$returnInfo)) {
            return false;
        }
        String this$returnInfoCode = this.getReturnInfoCode();
        String other$returnInfoCode = other.getReturnInfoCode();
        return !(this$returnInfoCode == null ? other$returnInfoCode != null : !this$returnInfoCode.equals(other$returnInfoCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AmapException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customErrorMsg = this.getCustomErrorMsg();
        result = result * 59 + ($customErrorMsg == null ? 43 : $customErrorMsg.hashCode());
        String $returnStatus = this.getReturnStatus();
        result = result * 59 + ($returnStatus == null ? 43 : $returnStatus.hashCode());
        String $returnInfo = this.getReturnInfo();
        result = result * 59 + ($returnInfo == null ? 43 : $returnInfo.hashCode());
        String $returnInfoCode = this.getReturnInfoCode();
        result = result * 59 + ($returnInfoCode == null ? 43 : $returnInfoCode.hashCode());
        return result;
    }

    public static final class Builder {
        private String returnStatus;
        private String returnInfo;
        private String returnInfoCode;

        private Builder() {
        }

        public Builder returnStatus(String returnStatus) {
            this.returnStatus = returnStatus;
            return this;
        }

        public Builder returnInfo(String returnInfo) {
            this.returnInfo = returnInfo;
            return this;
        }

        public Builder returnInfoCode(String returnInfoCode) {
            this.returnInfoCode = returnInfoCode;
            return this;
        }

        public AmapException build() {
            return new AmapException(this);
        }

        public String buildErrorMsg() {
            return Joiner.on((String)"\uff0c").skipNulls().join((Object)(this.returnStatus == null ? null : String.format("\u8fd4\u56de\u4ee3\u7801\uff1a[%s]", this.returnStatus)), (Object)(this.returnInfo == null ? null : String.format("\u8fd4\u56de\u4fe1\u606f\uff1a[%s]", this.returnInfo)), new Object[]{this.returnInfoCode == null ? null : String.format("\u7ed3\u679c\u4ee3\u7801\uff1a[%s]", this.returnInfoCode)});
        }
    }
}

