/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.gitea.model.NodeInfoServices;
import io.gitea.model.NodeInfoSoftware;
import io.gitea.model.NodeInfoUsage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NodeInfo contains standardized way of exposing metadata about a server running one of the distributed social networks")
public class NodeInfo {
    @SerializedName(value="metadata")
    private Object metadata = null;
    @SerializedName(value="openRegistrations")
    private Boolean openRegistrations = null;
    @SerializedName(value="protocols")
    private List<String> protocols = null;
    @SerializedName(value="services")
    private NodeInfoServices services = null;
    @SerializedName(value="software")
    private NodeInfoSoftware software = null;
    @SerializedName(value="usage")
    private NodeInfoUsage usage = null;
    @SerializedName(value="version")
    private String version = null;

    public NodeInfo metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public NodeInfo openRegistrations(Boolean openRegistrations) {
        this.openRegistrations = openRegistrations;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isOpenRegistrations() {
        return this.openRegistrations;
    }

    public void setOpenRegistrations(Boolean openRegistrations) {
        this.openRegistrations = openRegistrations;
    }

    public NodeInfo protocols(List<String> protocols) {
        this.protocols = protocols;
        return this;
    }

    public NodeInfo addProtocolsItem(String protocolsItem) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<String>();
        }
        this.protocols.add(protocolsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public NodeInfo services(NodeInfoServices services) {
        this.services = services;
        return this;
    }

    @ApiModelProperty(value="")
    public NodeInfoServices getServices() {
        return this.services;
    }

    public void setServices(NodeInfoServices services) {
        this.services = services;
    }

    public NodeInfo software(NodeInfoSoftware software) {
        this.software = software;
        return this;
    }

    @ApiModelProperty(value="")
    public NodeInfoSoftware getSoftware() {
        return this.software;
    }

    public void setSoftware(NodeInfoSoftware software) {
        this.software = software;
    }

    public NodeInfo usage(NodeInfoUsage usage) {
        this.usage = usage;
        return this;
    }

    @ApiModelProperty(value="")
    public NodeInfoUsage getUsage() {
        return this.usage;
    }

    public void setUsage(NodeInfoUsage usage) {
        this.usage = usage;
    }

    public NodeInfo version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo nodeInfo = (NodeInfo)o;
        return Objects.equals(this.metadata, nodeInfo.metadata) && Objects.equals(this.openRegistrations, nodeInfo.openRegistrations) && Objects.equals(this.protocols, nodeInfo.protocols) && Objects.equals(this.services, nodeInfo.services) && Objects.equals(this.software, nodeInfo.software) && Objects.equals(this.usage, nodeInfo.usage) && Objects.equals(this.version, nodeInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.openRegistrations, this.protocols, this.services, this.software, this.usage, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeInfo {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    openRegistrations: ").append(this.toIndentedString(this.openRegistrations)).append("\n");
        sb.append("    protocols: ").append(this.toIndentedString(this.protocols)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    software: ").append(this.toIndentedString(this.software)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

