/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Hook a hook is a web hook when one repository changed")
public class Hook {
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="config")
    private Map<String, String> config = null;
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="events")
    private List<String> events = null;
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt = null;

    public Hook active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Hook config(Map<String, String> config) {
        this.config = config;
        return this;
    }

    public Hook putConfigItem(String key, String configItem) {
        if (this.config == null) {
            this.config = new HashMap<String, String>();
        }
        this.config.put(key, configItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Hook createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Hook events(List<String> events) {
        this.events = events;
        return this;
    }

    public Hook addEventsItem(String eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public Hook id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Hook type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Hook updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hook hook = (Hook)o;
        return Objects.equals(this.active, hook.active) && Objects.equals(this.config, hook.config) && Objects.equals(this.createdAt, hook.createdAt) && Objects.equals(this.events, hook.events) && Objects.equals(this.id, hook.id) && Objects.equals(this.type, hook.type) && Objects.equals(this.updatedAt, hook.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.config, this.createdAt, this.events, this.id, this.type, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Hook {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

