/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.gitea.model.GitEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="GitTreeResponse returns a git tree")
public class GitTreeResponse {
    @SerializedName(value="page")
    private Long page = null;
    @SerializedName(value="sha")
    private String sha = null;
    @SerializedName(value="total_count")
    private Long totalCount = null;
    @SerializedName(value="tree")
    private List<GitEntry> tree = null;
    @SerializedName(value="truncated")
    private Boolean truncated = null;
    @SerializedName(value="url")
    private String url = null;

    public GitTreeResponse page(Long page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getPage() {
        return this.page;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public GitTreeResponse sha(String sha) {
        this.sha = sha;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public GitTreeResponse totalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public GitTreeResponse tree(List<GitEntry> tree) {
        this.tree = tree;
        return this;
    }

    public GitTreeResponse addTreeItem(GitEntry treeItem) {
        if (this.tree == null) {
            this.tree = new ArrayList<GitEntry>();
        }
        this.tree.add(treeItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<GitEntry> getTree() {
        return this.tree;
    }

    public void setTree(List<GitEntry> tree) {
        this.tree = tree;
    }

    public GitTreeResponse truncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public GitTreeResponse url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitTreeResponse gitTreeResponse = (GitTreeResponse)o;
        return Objects.equals(this.page, gitTreeResponse.page) && Objects.equals(this.sha, gitTreeResponse.sha) && Objects.equals(this.totalCount, gitTreeResponse.totalCount) && Objects.equals(this.tree, gitTreeResponse.tree) && Objects.equals(this.truncated, gitTreeResponse.truncated) && Objects.equals(this.url, gitTreeResponse.url);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.sha, this.totalCount, this.tree, this.truncated, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GitTreeResponse {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    tree: ").append(this.toIndentedString(this.tree)).append("\n");
        sb.append("    truncated: ").append(this.toIndentedString(this.truncated)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

