/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="CreateTeamOption options for creating a team")
public class CreateTeamOption {
    @SerializedName(value="can_create_org_repo")
    private Boolean canCreateOrgRepo = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="includes_all_repositories")
    private Boolean includesAllRepositories = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="permission")
    private PermissionEnum permission = null;
    @SerializedName(value="units")
    private List<String> units = null;
    @SerializedName(value="units_map")
    private Map<String, String> unitsMap = null;

    public CreateTeamOption canCreateOrgRepo(Boolean canCreateOrgRepo) {
        this.canCreateOrgRepo = canCreateOrgRepo;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isCanCreateOrgRepo() {
        return this.canCreateOrgRepo;
    }

    public void setCanCreateOrgRepo(Boolean canCreateOrgRepo) {
        this.canCreateOrgRepo = canCreateOrgRepo;
    }

    public CreateTeamOption description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTeamOption includesAllRepositories(Boolean includesAllRepositories) {
        this.includesAllRepositories = includesAllRepositories;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isIncludesAllRepositories() {
        return this.includesAllRepositories;
    }

    public void setIncludesAllRepositories(Boolean includesAllRepositories) {
        this.includesAllRepositories = includesAllRepositories;
    }

    public CreateTeamOption name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateTeamOption permission(PermissionEnum permission) {
        this.permission = permission;
        return this;
    }

    @ApiModelProperty(value="")
    public PermissionEnum getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionEnum permission) {
        this.permission = permission;
    }

    public CreateTeamOption units(List<String> units) {
        this.units = units;
        return this;
    }

    public CreateTeamOption addUnitsItem(String unitsItem) {
        if (this.units == null) {
            this.units = new ArrayList<String>();
        }
        this.units.add(unitsItem);
        return this;
    }

    @ApiModelProperty(example="[\"repo.code\",\"repo.issues\",\"repo.ext_issues\",\"repo.wiki\",\"repo.pulls\",\"repo.releases\",\"repo.projects\",\"repo.ext_wiki\"]", value="")
    public List<String> getUnits() {
        return this.units;
    }

    public void setUnits(List<String> units) {
        this.units = units;
    }

    public CreateTeamOption unitsMap(Map<String, String> unitsMap) {
        this.unitsMap = unitsMap;
        return this;
    }

    public CreateTeamOption putUnitsMapItem(String key, String unitsMapItem) {
        if (this.unitsMap == null) {
            this.unitsMap = new HashMap<String, String>();
        }
        this.unitsMap.put(key, unitsMapItem);
        return this;
    }

    @ApiModelProperty(example="{\"repo.code\":\"read\",\"repo.ext_issues\":\"none\",\"repo.ext_wiki\":\"none\",\"repo.issues\":\"write\",\"repo.projects\":\"none\",\"repo.pulls\":\"owner\",\"repo.releases\":\"none\",\"repo.wiki\":\"admin\"}", value="")
    public Map<String, String> getUnitsMap() {
        return this.unitsMap;
    }

    public void setUnitsMap(Map<String, String> unitsMap) {
        this.unitsMap = unitsMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTeamOption createTeamOption = (CreateTeamOption)o;
        return Objects.equals(this.canCreateOrgRepo, createTeamOption.canCreateOrgRepo) && Objects.equals(this.description, createTeamOption.description) && Objects.equals(this.includesAllRepositories, createTeamOption.includesAllRepositories) && Objects.equals(this.name, createTeamOption.name) && Objects.equals((Object)this.permission, (Object)createTeamOption.permission) && Objects.equals(this.units, createTeamOption.units) && Objects.equals(this.unitsMap, createTeamOption.unitsMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.canCreateOrgRepo, this.description, this.includesAllRepositories, this.name, this.permission, this.units, this.unitsMap});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTeamOption {\n");
        sb.append("    canCreateOrgRepo: ").append(this.toIndentedString(this.canCreateOrgRepo)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    includesAllRepositories: ").append(this.toIndentedString(this.includesAllRepositories)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString((Object)this.permission)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("    unitsMap: ").append(this.toIndentedString(this.unitsMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PermissionEnum {
        READ("read"),
        WRITE("write"),
        ADMIN("admin");

        private String value;

        private PermissionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PermissionEnum fromValue(String text) {
            for (PermissionEnum b : PermissionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PermissionEnum> {
            public void write(JsonWriter jsonWriter, PermissionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PermissionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PermissionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

