/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="CreateRepoOption options when creating repository")
public class CreateRepoOption {
    @SerializedName(value="auto_init")
    private Boolean autoInit = null;
    @SerializedName(value="default_branch")
    private String defaultBranch = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="gitignores")
    private String gitignores = null;
    @SerializedName(value="issue_labels")
    private String issueLabels = null;
    @SerializedName(value="license")
    private String license = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="private")
    private Boolean _private = null;
    @SerializedName(value="readme")
    private String readme = null;
    @SerializedName(value="template")
    private Boolean template = null;
    @SerializedName(value="trust_model")
    private TrustModelEnum trustModel = null;

    public CreateRepoOption autoInit(Boolean autoInit) {
        this.autoInit = autoInit;
        return this;
    }

    @ApiModelProperty(value="Whether the repository should be auto-initialized?")
    public Boolean isAutoInit() {
        return this.autoInit;
    }

    public void setAutoInit(Boolean autoInit) {
        this.autoInit = autoInit;
    }

    public CreateRepoOption defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @ApiModelProperty(value="DefaultBranch of the repository (used when initializes and in template)")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public CreateRepoOption description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the repository to create")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateRepoOption gitignores(String gitignores) {
        this.gitignores = gitignores;
        return this;
    }

    @ApiModelProperty(value="Gitignores to use")
    public String getGitignores() {
        return this.gitignores;
    }

    public void setGitignores(String gitignores) {
        this.gitignores = gitignores;
    }

    public CreateRepoOption issueLabels(String issueLabels) {
        this.issueLabels = issueLabels;
        return this;
    }

    @ApiModelProperty(value="Label-Set to use")
    public String getIssueLabels() {
        return this.issueLabels;
    }

    public void setIssueLabels(String issueLabels) {
        this.issueLabels = issueLabels;
    }

    public CreateRepoOption license(String license) {
        this.license = license;
        return this;
    }

    @ApiModelProperty(value="License to use")
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public CreateRepoOption name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the repository to create")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateRepoOption _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @ApiModelProperty(value="Whether the repository is private")
    public Boolean isPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public CreateRepoOption readme(String readme) {
        this.readme = readme;
        return this;
    }

    @ApiModelProperty(value="Readme of the repository to create")
    public String getReadme() {
        return this.readme;
    }

    public void setReadme(String readme) {
        this.readme = readme;
    }

    public CreateRepoOption template(Boolean template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(value="Whether the repository is template")
    public Boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(Boolean template) {
        this.template = template;
    }

    public CreateRepoOption trustModel(TrustModelEnum trustModel) {
        this.trustModel = trustModel;
        return this;
    }

    @ApiModelProperty(value="TrustModel of the repository")
    public TrustModelEnum getTrustModel() {
        return this.trustModel;
    }

    public void setTrustModel(TrustModelEnum trustModel) {
        this.trustModel = trustModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRepoOption createRepoOption = (CreateRepoOption)o;
        return Objects.equals(this.autoInit, createRepoOption.autoInit) && Objects.equals(this.defaultBranch, createRepoOption.defaultBranch) && Objects.equals(this.description, createRepoOption.description) && Objects.equals(this.gitignores, createRepoOption.gitignores) && Objects.equals(this.issueLabels, createRepoOption.issueLabels) && Objects.equals(this.license, createRepoOption.license) && Objects.equals(this.name, createRepoOption.name) && Objects.equals(this._private, createRepoOption._private) && Objects.equals(this.readme, createRepoOption.readme) && Objects.equals(this.template, createRepoOption.template) && Objects.equals((Object)this.trustModel, (Object)createRepoOption.trustModel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoInit, this.defaultBranch, this.description, this.gitignores, this.issueLabels, this.license, this.name, this._private, this.readme, this.template, this.trustModel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRepoOption {\n");
        sb.append("    autoInit: ").append(this.toIndentedString(this.autoInit)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    gitignores: ").append(this.toIndentedString(this.gitignores)).append("\n");
        sb.append("    issueLabels: ").append(this.toIndentedString(this.issueLabels)).append("\n");
        sb.append("    license: ").append(this.toIndentedString(this.license)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    readme: ").append(this.toIndentedString(this.readme)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    trustModel: ").append(this.toIndentedString((Object)this.trustModel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TrustModelEnum {
        DEFAULT("default"),
        COLLABORATOR("collaborator"),
        COMMITTER("committer"),
        COLLABORATORCOMMITTER("collaboratorcommitter");

        private String value;

        private TrustModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TrustModelEnum fromValue(String text) {
            for (TrustModelEnum b : TrustModelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TrustModelEnum> {
            public void write(JsonWriter jsonWriter, TrustModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TrustModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TrustModelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

