/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.gitea.model.CommitDateOptions;
import io.gitea.model.Identity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CreateFileOptions options for creating files Note: `author` and `committer` are optional (if only one is given, it will be used for the other, otherwise the authenticated user will be used)")
public class CreateFileOptions {
    @SerializedName(value="author")
    private Identity author = null;
    @SerializedName(value="branch")
    private String branch = null;
    @SerializedName(value="committer")
    private Identity committer = null;
    @SerializedName(value="content")
    private String content = null;
    @SerializedName(value="dates")
    private CommitDateOptions dates = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="new_branch")
    private String newBranch = null;
    @SerializedName(value="signoff")
    private Boolean signoff = null;

    public CreateFileOptions author(Identity author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="")
    public Identity getAuthor() {
        return this.author;
    }

    public void setAuthor(Identity author) {
        this.author = author;
    }

    public CreateFileOptions branch(String branch) {
        this.branch = branch;
        return this;
    }

    @ApiModelProperty(value="branch (optional) to base this file from. if not given, the default branch is used")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public CreateFileOptions committer(Identity committer) {
        this.committer = committer;
        return this;
    }

    @ApiModelProperty(value="")
    public Identity getCommitter() {
        return this.committer;
    }

    public void setCommitter(Identity committer) {
        this.committer = committer;
    }

    public CreateFileOptions content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="content must be base64 encoded")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public CreateFileOptions dates(CommitDateOptions dates) {
        this.dates = dates;
        return this;
    }

    @ApiModelProperty(value="")
    public CommitDateOptions getDates() {
        return this.dates;
    }

    public void setDates(CommitDateOptions dates) {
        this.dates = dates;
    }

    public CreateFileOptions message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="message (optional) for the commit of this file. if not supplied, a default message will be used")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CreateFileOptions newBranch(String newBranch) {
        this.newBranch = newBranch;
        return this;
    }

    @ApiModelProperty(value="new_branch (optional) will make a new branch from `branch` before creating the file")
    public String getNewBranch() {
        return this.newBranch;
    }

    public void setNewBranch(String newBranch) {
        this.newBranch = newBranch;
    }

    public CreateFileOptions signoff(Boolean signoff) {
        this.signoff = signoff;
        return this;
    }

    @ApiModelProperty(value="Add a Signed-off-by trailer by the committer at the end of the commit log message.")
    public Boolean isSignoff() {
        return this.signoff;
    }

    public void setSignoff(Boolean signoff) {
        this.signoff = signoff;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFileOptions createFileOptions = (CreateFileOptions)o;
        return Objects.equals(this.author, createFileOptions.author) && Objects.equals(this.branch, createFileOptions.branch) && Objects.equals(this.committer, createFileOptions.committer) && Objects.equals(this.content, createFileOptions.content) && Objects.equals(this.dates, createFileOptions.dates) && Objects.equals(this.message, createFileOptions.message) && Objects.equals(this.newBranch, createFileOptions.newBranch) && Objects.equals(this.signoff, createFileOptions.signoff);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.branch, this.committer, this.content, this.dates, this.message, this.newBranch, this.signoff);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFileOptions {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    committer: ").append(this.toIndentedString(this.committer)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    dates: ").append(this.toIndentedString(this.dates)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    newBranch: ").append(this.toIndentedString(this.newBranch)).append("\n");
        sb.append("    signoff: ").append(this.toIndentedString(this.signoff)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

