/*
 * Decompiled with CFR 0.152.
 */
package io.gitea.model;

import com.google.gson.annotations.SerializedName;
import io.gitea.model.CommitAffectedFiles;
import io.gitea.model.CommitMeta;
import io.gitea.model.CommitStats;
import io.gitea.model.RepoCommit;
import io.gitea.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class Commit {
    @SerializedName(value="author")
    private User author = null;
    @SerializedName(value="commit")
    private RepoCommit commit = null;
    @SerializedName(value="committer")
    private User committer = null;
    @SerializedName(value="created")
    private OffsetDateTime created = null;
    @SerializedName(value="files")
    private List<CommitAffectedFiles> files = null;
    @SerializedName(value="html_url")
    private String htmlUrl = null;
    @SerializedName(value="parents")
    private List<CommitMeta> parents = null;
    @SerializedName(value="sha")
    private String sha = null;
    @SerializedName(value="stats")
    private CommitStats stats = null;
    @SerializedName(value="url")
    private String url = null;

    public Commit author(User author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="")
    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public Commit commit(RepoCommit commit) {
        this.commit = commit;
        return this;
    }

    @ApiModelProperty(value="")
    public RepoCommit getCommit() {
        return this.commit;
    }

    public void setCommit(RepoCommit commit) {
        this.commit = commit;
    }

    public Commit committer(User committer) {
        this.committer = committer;
        return this;
    }

    @ApiModelProperty(value="")
    public User getCommitter() {
        return this.committer;
    }

    public void setCommitter(User committer) {
        this.committer = committer;
    }

    public Commit created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Commit files(List<CommitAffectedFiles> files) {
        this.files = files;
        return this;
    }

    public Commit addFilesItem(CommitAffectedFiles filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<CommitAffectedFiles>();
        }
        this.files.add(filesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<CommitAffectedFiles> getFiles() {
        return this.files;
    }

    public void setFiles(List<CommitAffectedFiles> files) {
        this.files = files;
    }

    public Commit htmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
        return this;
    }

    @ApiModelProperty(value="")
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public void setHtmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
    }

    public Commit parents(List<CommitMeta> parents) {
        this.parents = parents;
        return this;
    }

    public Commit addParentsItem(CommitMeta parentsItem) {
        if (this.parents == null) {
            this.parents = new ArrayList<CommitMeta>();
        }
        this.parents.add(parentsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<CommitMeta> getParents() {
        return this.parents;
    }

    public void setParents(List<CommitMeta> parents) {
        this.parents = parents;
    }

    public Commit sha(String sha) {
        this.sha = sha;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public Commit stats(CommitStats stats) {
        this.stats = stats;
        return this;
    }

    @ApiModelProperty(value="")
    public CommitStats getStats() {
        return this.stats;
    }

    public void setStats(CommitStats stats) {
        this.stats = stats;
    }

    public Commit url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return Objects.equals(this.author, commit.author) && Objects.equals(this.commit, commit.commit) && Objects.equals(this.committer, commit.committer) && Objects.equals(this.created, commit.created) && Objects.equals(this.files, commit.files) && Objects.equals(this.htmlUrl, commit.htmlUrl) && Objects.equals(this.parents, commit.parents) && Objects.equals(this.sha, commit.sha) && Objects.equals(this.stats, commit.stats) && Objects.equals(this.url, commit.url);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.commit, this.committer, this.created, this.files, this.htmlUrl, this.parents, this.sha, this.stats, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Commit {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    commit: ").append(this.toIndentedString(this.commit)).append("\n");
        sb.append("    committer: ").append(this.toIndentedString(this.committer)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    htmlUrl: ").append(this.toIndentedString(this.htmlUrl)).append("\n");
        sb.append("    parents: ").append(this.toIndentedString(this.parents)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

